/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Button;
import org.symphonyoss.symphony.messageml.elements.Checkbox;
import org.symphonyoss.symphony.messageml.elements.Dialog;
import org.symphonyoss.symphony.messageml.elements.DialogChild;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.Radio;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.FormNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class Form
extends Element {
    public static final String MESSAGEML_TAG = "form";
    private static final String ID_ATTR = "id";
    private static final String MULTI_SUBMIT = "multi-submit";
    private static final String PRESENTATIONML_MULTI_SUBMIT = "data-multi-submit";
    private static final int MAX_COUNT_PER_CHILD_TYPE = 50;
    private static final int MAX_LENGTH = 64;
    private static final String ERR_MSG_MISSING_ACTION_BTN = "The form with id '%s' should have at least one action button";
    private static final List<String> ALLOWED_MULTI_SUBMIT = Arrays.asList("reset", "no-reset");

    public Form(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
    }

    @Override
    public Boolean hasIdAttribute() {
        return true;
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        this.assertNotParentAtAnyLevel(Collections.singletonList(this.getClass()));
        this.assertChildrenNotExceedingMaxCount(Arrays.asList(Checkbox.class, Radio.class), 50);
        this.assertAttributeNotBlank(ID_ATTR);
        if (!this.getParent().getClass().equals(Dialog.class)) {
            this.assertAtLeastOneActionButton();
        } else if (this.format == FormatEnum.MESSAGEML) {
            this.assertContentModel(Arrays.asList(DialogChild.Footer.class, DialogChild.Title.class, DialogChild.Body.class));
        } else {
            this.assertContentModel((Element e) -> e.isPresentationMLElement("dialog-title") || e.isPresentationMLElement("dialog-body") || e.isPresentationMLElement("dialog-footer"), (Element child) -> "Element \"" + child.getMessageMLTag() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
        }
        if (this.getAttribute(MULTI_SUBMIT) != null) {
            this.assertAttributeMaxLength(MULTI_SUBMIT, 64);
            this.assertAttributeValue(MULTI_SUBMIT, ALLOWED_MULTI_SUBMIT);
        }
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "id": 
            case "multi-submit": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new FormNode();
    }

    private void assertAtLeastOneActionButton() throws InvalidInputException {
        boolean hasActionButton = this.findElements(Button.class).stream().anyMatch(element -> "action".equals(element.getAttribute("type")));
        if (!hasActionButton) {
            throw new InvalidInputException(String.format(ERR_MSG_MISSING_ACTION_BTN, this.getAttribute(ID_ATTR)));
        }
    }

    @Override
    void updateBiContext(BiContext context) {
        HashMap<String, Object> formMap = new HashMap<String, Object>();
        if (this.getAttribute(MULTI_SUBMIT) != null) {
            formMap.put(BiFields.MULTI_SUBMIT.getValue(), 1);
        }
        context.addItem(new BiItem(BiFields.FORM.getValue(), formMap));
    }

    @Override
    void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        if (this.getAttribute(ID_ATTR) != null) {
            presentationAttrs.put(ID_ATTR, this.getAttribute(ID_ATTR));
        }
        if (this.getAttribute(MULTI_SUBMIT) != null) {
            presentationAttrs.put(PRESENTATIONML_MULTI_SUBMIT, this.getAttribute(MULTI_SUBMIT));
        }
        out.openElement(this.getPresentationMLTag(), presentationAttrs);
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }
}

