/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.Bold;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.GroupedElement;
import org.symphonyoss.symphony.messageml.elements.Italic;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.RadioNode;

public class Radio
extends GroupedElement
implements LabelableElement {
    public static final String MESSAGEML_TAG = "radio";
    public static final String PRESENTATIONML_INPUT_TYPE = "radio";
    public static final String PRESENTATIONML_DIV_CLASS = "radio-group";
    private static final String NAME_ATTR = "name";
    private static final String MARKDOWN = "Radio Button";

    public Radio(Element parent, FormatEnum messageFormat) {
        super(parent, "radio", messageFormat);
    }

    @Override
    public Node asMarkdown() {
        if (this.hasExactNumberOfChildren(1)) {
            return new RadioNode(this.getChildren().get(0).asText());
        }
        return new RadioNode();
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        this.assertAttributeNotBlank(NAME_ATTR);
        if (this.getAttribute("checked") != null) {
            this.assertAttributeValue("checked", Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (this.getAttribute("disabled") != null) {
            this.assertAttributeValue("disabled", Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (this.getAttribute("readonly") != null) {
            this.assertAttributeValue("readonly", Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (!this.getChildren().isEmpty()) {
            this.assertContentModel(Arrays.asList(TextNode.class, Bold.class, Italic.class));
        }
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "checked": 
            case "name": 
            case "value": 
            case "label": 
            case "disabled": 
            case "readonly": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "id": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    protected String getPresentationMLInputType() {
        return "radio";
    }

    @Override
    protected String getPresentationMLDivClass() {
        return PRESENTATIONML_DIV_CLASS;
    }

    @Override
    public String getElementId() {
        return "radio";
    }

    @Override
    public void updateBiContext(BiContext context) {
        HashMap<String, Object> attributesMapBi = new HashMap<String, Object>();
        attributesMapBi.put(BiFields.OPTIONS_COUNT.getValue(), 1);
        this.putOneIfPresent(attributesMapBi, BiFields.LABEL.getValue(), "label");
        this.computeAndPutDefault(context, attributesMapBi);
        context.updateItemCount(BiFields.RADIO.getValue(), attributesMapBi);
    }

    private void computeAndPutDefault(BiContext context, Map<String, Object> attributesMapBi) {
        String isChecked = this.getAttribute("checked");
        boolean isDefaultAlreadySet = context.isAttributeSet(BiFields.RADIO.getValue(), BiFields.DEFAULT.getValue());
        if (isChecked != null && Boolean.TRUE.equals(Boolean.valueOf(isChecked)) && !isDefaultAlreadySet) {
            attributesMapBi.put(BiFields.DEFAULT.getValue(), 1);
        }
    }
}

