/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.Option;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.SelectNode;

public class Select
extends FormElement
implements LabelableElement,
TooltipableElement {
    public static final String MESSAGEML_TAG = "select";
    public static final String ELEMENT_ID = "dropdown";
    private static final String REQUIRED_ATTR = "required";
    private static final String OPTION_SELECTED_ATTR = "selected";
    private static final String DATA_PLACEHOLDER_ATTR = "data-placeholder";
    private static final String MULTIPLE_ATTR = "multiple";
    private static final String MML_MIN_ATTR = "min";
    private static final String MIN_ATTR = "data-min";
    private static final String MML_MAX_ATTR = "max";
    private static final String MAX_ATTR = "data-max";
    protected static final String DISABLED_ATTR = "disabled";
    protected static final String READONLY_ATTR = "readonly";
    private static final String AUTO_SUBMIT_ATTR = "data-auto-submit";
    private static final String MML_AUTO_SUBMIT_ATTR = "auto-submit";

    public Select(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    public Node asMarkdown() {
        return new SelectNode(this.getAttribute(DATA_PLACEHOLDER_ATTR), this.getAttribute("label"), this.getAttribute("title"));
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        this.assertAttributeNotBlank("name");
        this.assertContentModel(Collections.singleton(Option.class));
        this.assertContainsChildOfType(Collections.singleton(Option.class));
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (this.getAttribute(MULTIPLE_ATTR) != null) {
            this.assertAttributeValue(MULTIPLE_ATTR, Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (this.getAttribute(DISABLED_ATTR) != null) {
            this.assertAttributeValue(DISABLED_ATTR, Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (this.getAttribute(READONLY_ATTR) != null) {
            this.assertAttributeValue(READONLY_ATTR, Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (this.getAttribute(AUTO_SUBMIT_ATTR) != null) {
            this.assertAttributeValue(AUTO_SUBMIT_ATTR, Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        boolean multipleAttributeValue = Boolean.parseBoolean(this.getAttribute(MULTIPLE_ATTR));
        if (this.getAttribute(MIN_ATTR) != null && !multipleAttributeValue) {
            throw new InvalidInputException("Attribute \"min\" is not allowed. Attribute \"multiple\" missing");
        }
        if (this.getAttribute(MAX_ATTR) != null && !multipleAttributeValue) {
            throw new InvalidInputException("Attribute \"max\" is not allowed. Attribute \"multiple\" missing");
        }
        int min = this.checkIntegerAttribute(MIN_ATTR, 0, "Attribute \"min\" is not valid, it must be >= 0");
        int max = this.checkIntegerAttribute(MAX_ATTR, 1, "Attribute \"max\" is not valid, it must be >= 1");
        if (max > 0 && min > max) {
            throw new InvalidInputException("Attribute \"min\" is greater than attribute \"max\"");
        }
        if (multipleAttributeValue && Boolean.parseBoolean(this.getAttribute(REQUIRED_ATTR)) && this.getAttribute(MIN_ATTR) != null && min == 0) {
            throw new InvalidInputException("Attribute \"min\" cannot be 0 if \"required\" is true");
        }
        if (!multipleAttributeValue) {
            this.assertOnlyOneOptionSelected();
        }
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "required": 
            case "data-placeholder": 
            case "label": 
            case "title": 
            case "multiple": 
            case "disabled": 
            case "readonly": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "min": {
                this.setAttribute(MIN_ATTR, this.getStringAttribute(item));
                break;
            }
            case "max": {
                this.setAttribute(MAX_ATTR, this.getStringAttribute(item));
                break;
            }
            case "auto-submit": {
                this.setAttribute(AUTO_SUBMIT_ATTR, this.getStringAttribute(item));
                break;
            }
            case "id": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public String getElementId() {
        return ELEMENT_ID;
    }

    @Override
    public void updateBiContext(BiContext context) {
        HashMap<String, Object> attributesMapBi = new HashMap<String, Object>();
        this.putOneIfPresent(attributesMapBi, BiFields.TITLE.getValue(), "title");
        this.putOneIfPresent(attributesMapBi, BiFields.LABEL.getValue(), "label");
        this.putOneIfPresent(attributesMapBi, BiFields.PLACEHOLDER.getValue(), DATA_PLACEHOLDER_ATTR);
        this.putOneIfPresent(attributesMapBi, BiFields.REQUIRED.getValue(), REQUIRED_ATTR);
        this.putOneIfPresent(attributesMapBi, BiFields.MULTI_SELECT.getValue(), MULTIPLE_ATTR);
        attributesMapBi.put(BiFields.OPTIONS_COUNT.getValue(), this.countChildrenOfType(Option.class));
        attributesMapBi.put(BiFields.DEFAULT.getValue(), this.isAtLeastOneOptionSelected());
        context.addItem(new BiItem(BiFields.SELECT.getValue(), attributesMapBi));
    }

    private int isAtLeastOneOptionSelected() {
        return this.getChildren().stream().anyMatch(child -> child.getAttribute(OPTION_SELECTED_ATTR) != null) ? 1 : 0;
    }

    private void assertOnlyOneOptionSelected() throws InvalidInputException {
        long numberOfSelectedOptions = this.getChildren().stream().map(child -> child.getAttribute(OPTION_SELECTED_ATTR)).filter(selectedAttr -> selectedAttr != null && selectedAttr.equalsIgnoreCase(Boolean.TRUE.toString())).count();
        if (numberOfSelectedOptions > 1L) {
            throw new InvalidInputException("Element \"select\" can only have one selected \"option\"");
        }
    }
}

