/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class Code
extends Element {
    public static final String MESSAGEML_TAG = "code";
    private static final String MML_LANGUAGE_ATTR = "language";
    private static final String PML_LANGUAGE_ATTR = "data-language";
    public static final char MARKDOWN_DELIMITER_CHAR = '`';
    public static final int MARKDOWN_DELIMITER_LENGTH = 3;
    private static final int MARKDOWN_DELIMITER_INDENT = 0;
    private static final List<String> SUPPORTED_LANGUAGES = Arrays.asList("plaintext", "c", "cpp", "csharp", "css", "html", "java", "js", "jsx", "php", "python", "r", "typescript", "tsx", "markdown", "json", "scala", "shell", "yaml");

    public Code(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    public Code(Element parent, String language) {
        super(parent, MESSAGEML_TAG);
        this.setAttribute(PML_LANGUAGE_ATTR, language);
    }

    @Override
    void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "language": 
            case "data-language": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            default: {
                super.buildAttribute(parser, item);
            }
        }
    }

    @Override
    void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getAttribute(MML_LANGUAGE_ATTR) != null) {
            attrs.put(PML_LANGUAGE_ATTR, this.getAttribute(MML_LANGUAGE_ATTR));
        }
        if (this.getAttribute(PML_LANGUAGE_ATTR) != null) {
            attrs.put(PML_LANGUAGE_ATTR, this.getAttribute(PML_LANGUAGE_ATTR));
        }
        out.openElement(MESSAGEML_TAG, attrs);
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    @Override
    public Node asMarkdown() {
        FencedCodeBlock node = new FencedCodeBlock();
        node.setFenceChar('`');
        node.setFenceLength(3);
        node.setFenceIndent(0);
        if (this.getAttribute(MML_LANGUAGE_ATTR) != null) {
            node.setInfo(this.getAttribute(MML_LANGUAGE_ATTR));
        }
        if (this.getAttribute(PML_LANGUAGE_ATTR) != null) {
            node.setInfo(this.getAttribute(PML_LANGUAGE_ATTR));
        }
        return node;
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(MML_LANGUAGE_ATTR))) {
            this.assertAttributeValue(MML_LANGUAGE_ATTR, SUPPORTED_LANGUAGES);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAttribute(PML_LANGUAGE_ATTR))) {
            this.assertAttributeValue(PML_LANGUAGE_ATTR, SUPPORTED_LANGUAGES);
        }
        this.assertPreformattedOrPhrasingContent();
    }

    @Override
    public String getPresentationMLTag() {
        return super.getPresentationMLTag();
    }

    @Override
    void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        context.updateItemCount(BiFields.CODE.getValue());
    }
}

