/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Entity;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Node;

abstract class Keyword
extends Entity {
    private static final String ATTR_TAG = "tag";
    private static final String ENTITY_ID_PREFIX = "keyword";
    protected String tag;

    Keyword(Element parent, String messageMLTag, String presentationMlTag, FormatEnum format) {
        super(parent, messageMLTag, presentationMlTag, format);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, Node item) throws InvalidInputException {
        if (ATTR_TAG.equals(item.getNodeName())) {
            this.tag = item.getTextContent();
        } else {
            super.buildAttribute(parser, item);
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.tag == null) {
            throw new InvalidInputException("The attribute \"tag\" is required");
        }
        super.validate();
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    protected String getEntityIdPrefix() {
        return ENTITY_ID_PREFIX;
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.printElement(this.presentationMLTag, this.asText(), "class", "entity", "data-entity-id", this.entityId);
    }

    @Override
    protected String getEntityValue() {
        return this.getTag();
    }

    public String toString() {
        return "Keyword(" + this.getTag() + ")";
    }
}

