/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.commonmark.node.Document;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Chime;
import org.symphonyoss.symphony.messageml.elements.Dialog;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.Tag;
import org.symphonyoss.symphony.messageml.elements.UIAction;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.IDataProvider;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.symphonyoss.symphony.messageml.util.instrument.resolver.InstrumentKind;
import org.symphonyoss.symphony.messageml.util.instrument.resolver.InstrumentResolution;
import org.symphonyoss.symphony.messageml.util.instrument.resolver.MarketSector;
import org.symphonyoss.symphony.messageml.util.instrument.resolver.ResolutionResults;

public class MessageML
extends Element {
    public static final String MESSAGEML_VERSION = "2.0";
    public static final String MESSAGEML_TAG = "messageML";
    public static final String MESSAGEML_XMLNS = "https://finos.org/messageml";
    public static final String PRESENTATIONML_TAG = "div";
    private static final String ATTR_FORMAT = "data-format";
    private static final String ATTR_VERSION = "data-version";
    private static final String ATTR_XMLNS = "xmlns";
    private static final String PRESENTATIONML_FORMAT = "PresentationML";
    private String version;
    private boolean chime;
    private String xmlns;

    public MessageML(FormatEnum format, String version) {
        super(null, MESSAGEML_TAG, format);
        this.version = version;
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        if (this.getFormat() == FormatEnum.PRESENTATIONML) {
            switch (item.getNodeName()) {
                case "data-format": {
                    this.setAttribute(ATTR_FORMAT, this.getStringAttribute(item));
                    break;
                }
                case "data-version": {
                    this.version = this.getStringAttribute(item);
                    break;
                }
                default: {
                    super.buildAttribute(parser, item);
                    break;
                }
            }
        } else {
            switch (item.getNodeName()) {
                case "xmlns": {
                    this.xmlns = this.getStringAttribute(item);
                    break;
                }
                default: {
                    super.buildAttribute(parser, item);
                }
            }
        }
    }

    public Document asMarkdown() throws InvalidInputException {
        Document root = new Document();
        try {
            this.buildMarkdown((Node)root);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidInputException("Failed to build Markdown: " + e.getMessage());
        }
        return root;
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.openElement(PRESENTATIONML_TAG, ATTR_FORMAT, PRESENTATIONML_FORMAT, ATTR_VERSION, this.version);
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        if (parent == null) {
            parent = new ObjectNode(JsonNodeFactory.instance);
        }
        this.buildEntityJson(parent);
        return parent;
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.format == FormatEnum.MESSAGEML) {
            this.assertNoAttributes();
        } else if (!(this.format != FormatEnum.PRESENTATIONML || PRESENTATIONML_FORMAT.equalsIgnoreCase(this.getAttribute(ATTR_FORMAT)) && this.version != null)) {
            throw new InvalidInputException("Malformed PresentationML. The attributes \"data-format\" and \"data-version\" are required.");
        }
        if (this.isChime() && (this.getChildren().size() != 1 || !(this.getChild(0) instanceof Chime))) {
            throw new InvalidInputException("Chime messages may not have any other content");
        }
        this.validateTargetIdForUIActions();
    }

    public boolean isChime() {
        return this.chime;
    }

    public void setChime(boolean chime) {
        this.chime = chime;
    }

    @Override
    public String getPresentationMLTag() {
        return PRESENTATIONML_TAG;
    }

    private void validateTargetIdForUIActions() throws InvalidInputException {
        List<Element> uiActionWithTargetId = this.findElements((Element element) -> element.getClass() == UIAction.class && element.getAttribute("target-id") != null);
        for (Element uiAction : uiActionWithTargetId) {
            Dialog dialog = this.findMatchingDialog((UIAction)uiAction);
            uiAction.setAttribute("target-id", dialog.getPresentationMlIdAttribute());
        }
    }

    public void enhanceFinancialTags(MessageML result, IDataProvider dataProvider) throws InvalidInputException {
        List<Tag> elements = result.getChildrenOfType(Tag.class).stream().map(element -> (Tag)Tag.class.cast(element)).collect(Collectors.toList());
        if (elements != null && !elements.isEmpty()) {
            this.processFinancialTags(elements, dataProvider);
        }
    }

    private void processFinancialTags(List<Tag> elements, IDataProvider dataProvider) throws InvalidInputException {
        List<Pair> instrumentResolutionMap = IntStream.range(0, elements.size()).mapToObj(index -> this.buildInstrumentResolutionRequest((Tag)elements.get(index), index)).collect(Collectors.toList());
        List<InstrumentResolution> criteria = instrumentResolutionMap.stream().map(Pair::getLeft).collect(Collectors.toList());
        ResolutionResults results = dataProvider.getFinTagPresentation(criteria);
        instrumentResolutionMap.forEach(entry -> {
            String resolutionId = ((InstrumentResolution)entry.getLeft()).getResolutionId();
            if (results != null && results.getInstruments() != null && results.getInstruments().containsKey(resolutionId)) {
                ((Tag)entry.getRight()).setInstrument(results.getInstruments().get(resolutionId).getInstrument());
            }
        });
        for (Tag element : elements) {
            element.validateFallBackTicker();
        }
    }

    private Pair<InstrumentResolution, Tag> buildInstrumentResolutionRequest(Tag tag, Integer order) {
        InstrumentResolution resolution = new InstrumentResolution();
        resolution.setResolutionId(order.toString());
        resolution.setBbgCompTicker(tag.getTagAttributes().getBbgcompticker());
        resolution.setFigi(tag.getTagAttributes().getFigi());
        resolution.setFigiTicker(tag.getTagAttributes().getFigiTicker());
        resolution.setUniqueId(tag.getTagAttributes().getUniqueId());
        resolution.setIsin(tag.getTagAttributes().getIsin());
        resolution.setUsCode(tag.getTagAttributes().getUscode());
        resolution.setFullBbgCompTicker(tag.getTagAttributes().getFullBbgCompTicker());
        resolution.setLocalCode(tag.getTagAttributes().getLocalcode());
        resolution.setOperationalMic(tag.getTagAttributes().getOperationalMic());
        resolution.setInstrumentClass(InstrumentKind.fromValue(tag.getTagAttributes().getInstrumentclass()));
        resolution.setCountryCode(tag.getTagAttributes().getCountrycode());
        resolution.setReturnMainListing(tag.getTagAttributes().getReturnMainListing());
        resolution.setBbgMarketSector(MarketSector.fromValue(tag.getTagAttributes().getBbgmarketsector()));
        return new ImmutablePair((Object)resolution, (Object)tag);
    }
}

