/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Entity;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.TagNode;
import org.symphonyoss.symphony.messageml.util.TagAttributes;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.symphonyoss.symphony.messageml.util.instrument.resolver.Instrument;
import org.symphonyoss.symphony.messageml.util.instrument.resolver.InstrumentKind;
import org.symphonyoss.symphony.messageml.util.instrument.resolver.MarketSector;

public class Tag
extends Entity {
    public static final String MESSAGEML_TAG = "tag";
    public static final String PREFIX = "$";
    public static final String ENTITY_TYPE = "org.symphonyoss.fin.security";
    private static final String ENTITY_SUBTYPE = "org.symphonyoss.fin.security.id.ticker";
    private static final String ENTITY_VERSION = "2.0";
    private static final String LEGACY_ENTITY_VERSION = "1.0";
    private TagAttributes tagAttributes = new TagAttributes();
    private Instrument instrument;

    public Tag(Element parent, int entityIndex) {
        this(parent, "span", entityIndex, FormatEnum.MESSAGEML);
    }

    private Tag(Element parent, String presentationMlTag, Integer entityIndex, FormatEnum format) {
        super(parent, MESSAGEML_TAG, presentationMlTag, format);
        this.entityId = this.getEntityId(entityIndex);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "fullbbgcompticker": {
                this.tagAttributes.setFullBbgCompTicker(this.getStringAttribute(item));
                break;
            }
            case "unique-id": {
                this.tagAttributes.setUniqueId(this.getStringAttribute(item));
                break;
            }
            case "figi": {
                this.tagAttributes.setFigi(this.getStringAttribute(item));
                break;
            }
            case "bbgcompticker": {
                this.tagAttributes.setBbgcompticker(this.getStringAttribute(item));
                break;
            }
            case "figi-ticker": {
                this.tagAttributes.setFigiTicker(this.getStringAttribute(item));
                break;
            }
            case "us-code": {
                this.tagAttributes.setUscode(this.getStringAttribute(item));
                break;
            }
            case "isin": {
                this.tagAttributes.setIsin(this.getStringAttribute(item));
                break;
            }
            case "local-code": {
                this.tagAttributes.setLocalcode(this.getStringAttribute(item));
                break;
            }
            case "instrument-class": {
                this.tagAttributes.setInstrumentclass(this.getStringAttribute(item));
                break;
            }
            case "bbgmarket-sector": {
                this.tagAttributes.setBbgmarketsector(this.getStringAttribute(item));
                break;
            }
            case "return-main-listing": {
                this.tagAttributes.setReturnMainListing(this.getStringAttribute(item));
                break;
            }
            case "country-code": {
                this.tagAttributes.setCountrycode(this.getStringAttribute(item));
                break;
            }
            case "operational-mic": {
                this.tagAttributes.setOperationalMic(this.getStringAttribute(item));
                break;
            }
            case "fallback-ticker": {
                this.tagAttributes.setFallbackTicker(this.getStringAttribute(item));
                break;
            }
            default: {
                super.buildAttribute(parser, item);
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.tagAttributes.getInstrumentclass() != null && InstrumentKind.fromValue(this.tagAttributes.getInstrumentclass()) == null) {
            throw new InvalidInputException("the attribute \"instrument-class\" must be one of those values " + InstrumentKind.toValues());
        }
        if (this.tagAttributes.getBbgmarketsector() != null && MarketSector.fromValue(this.tagAttributes.getBbgmarketsector()) == null) {
            throw new InvalidInputException("the attribute \"bbgmarket-sector\" must be one of those values " + MarketSector.toValues());
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.printElement(this.presentationMLTag, this.asText(), "class", "entity", "data-entity-id", this.entityId);
    }

    @Override
    Node asMarkdown() throws InvalidInputException {
        String text = this.instrument == null ? this.tagAttributes.getFallbackTicker() : this.instrument.getRootBbgCompTicker();
        JsonNode data = this.instrument != null ? (JsonNode)MAPPER.convertValue((Object)this.instrument, JsonNode.class) : null;
        return new TagNode(PREFIX, text, data);
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        ObjectNode node = super.asEntityJson(parent);
        if (this.instrument != null) {
            this.enhanceInstrumentEntityJson(node);
        }
        return node;
    }

    private void enhanceInstrumentEntityJson(ObjectNode node) {
        ArrayNode idArray = (ArrayNode)ArrayNode.class.cast(node.get("id"));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.id.uniqueId", this.instrument.getUniqueId()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.id.fullBbgTicker", this.instrument.getFullBbgCompTicker()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.bbgcompticker", this.instrument.getBbgCompTicker()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.id.isin", this.instrument.getIsin()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.id.figi", this.instrument.getFigi()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.id.figiTicker", this.instrument.getFigiTicker()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.id.lei", this.instrument.getFigiTicker()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.id.localCode", this.instrument.getLocalCode()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.id.operationalMic", this.instrument.getOperationalMic()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.countryCode", this.instrument.getCountryCode()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.countryName", this.instrument.getCountryName()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.exchangeName", this.instrument.getExchangeName()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.displayName", this.instrument.getDisplayName()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.currency", this.instrument.getCurrency()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.instrumentTypeCode", this.instrument.getInstrumentTypeCode()));
        idArray.add((JsonNode)this.buildNode("org.symphonyoss.fin.security.instrumentTypeName", this.instrument.getInstrumentTypeName()));
    }

    private ObjectNode buildNode(String type, String value) {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put("type", type);
        node.put("value", value);
        return node;
    }

    @Override
    protected String getEntityIdPrefix() {
        return MESSAGEML_TAG;
    }

    @Override
    protected String getEntityValue() {
        return this.instrument == null ? this.tagAttributes.getFallbackTicker() : this.instrument.getRootBbgCompTicker();
    }

    @Override
    protected String getEntitySubType() {
        return ENTITY_SUBTYPE;
    }

    @Override
    protected String getEntityVersion() {
        return this.instrument == null ? LEGACY_ENTITY_VERSION : ENTITY_VERSION;
    }

    @Override
    protected String getEntityType() {
        return ENTITY_TYPE;
    }

    @Override
    public String asText() {
        String text = this.instrument == null ? this.tagAttributes.getFallbackTicker() : this.instrument.getRootBbgCompTicker();
        return PREFIX + text;
    }

    public void validateFallBackTicker() throws InvalidInputException {
        if (this.instrument == null && StringUtils.isBlank((CharSequence)this.tagAttributes.getFallbackTicker())) {
            throw new InvalidInputException("No instrument found , \"fallback-ticker\" attribute is required");
        }
    }

    @Override
    public void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        context.updateItemCount(BiFields.HASHTAGS.getValue());
        context.addItem(new BiItem(BiFields.ENTITY.getValue(), Collections.singletonMap(BiFields.ENTITY_TYPE.getValue(), this.getEntityType())));
    }

    public TagAttributes getTagAttributes() {
        return this.tagAttributes;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }
}

