/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.MinMaxLengthElement;
import org.symphonyoss.symphony.messageml.elements.RegexElement;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.TextFieldNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class TextField
extends FormElement
implements RegexElement,
LabelableElement,
TooltipableElement,
MinMaxLengthElement {
    public static final String MESSAGEML_TAG = "text-field";
    public static final String ELEMENT_ID = "textfield";
    public static final String PRESENTATIONML_INPUT_TYPE = "text";
    private static final String REQUIRED_ATTR = "required";
    private static final String MASKED_ATTR = "masked";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String VALUE_ATTR = "value";
    private static final String DISABLED_ATTR = "disabled";
    private static final String READONLY_ATTR = "readonly";
    private static final String PRESENTATIONML_MASKED_ATTR = "data-masked";
    private static final String MML_AUTO_SUBMIT_ATTR = "auto-submit";
    private static final String AUTO_SUBMIT_ATTR = "data-auto-submit";
    private static final Set<String> VALID_BOOLEAN_VALUES = new HashSet<String>(Arrays.asList("true", "false"));
    private static final Integer MIN_ALLOWED_LENGTH = 1;
    private static final Integer MAX_ALLOWED_LENGTH = 128;
    private static final String MARKDOWN = "Text Field";

    public TextField(Element parent, FormatEnum messageFormat) {
        super(parent, MESSAGEML_TAG, messageFormat);
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_BOOLEAN_VALUES);
        }
        if (this.getAttribute(MASKED_ATTR) != null) {
            this.assertAttributeValue(MASKED_ATTR, VALID_BOOLEAN_VALUES);
        }
        if (this.getAttribute(DISABLED_ATTR) != null) {
            this.assertAttributeValue(DISABLED_ATTR, VALID_BOOLEAN_VALUES);
        }
        if (this.getAttribute(READONLY_ATTR) != null) {
            this.assertAttributeValue(READONLY_ATTR, VALID_BOOLEAN_VALUES);
        }
        if (this.getAttribute(AUTO_SUBMIT_ATTR) != null) {
            this.assertAttributeValue(AUTO_SUBMIT_ATTR, VALID_BOOLEAN_VALUES);
        }
        this.assertAttributeNotBlank("name");
        this.assertContentModel(Collections.singleton(TextNode.class));
        this.validateMinAndMaxLengths();
    }

    @Override
    public void buildAll(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(parser, element);
                break;
            }
            case PRESENTATIONML: {
                this.buildAllFromPresentationML(parser, element);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new TextFieldNode(this.getAttribute(PLACEHOLDER_ATTR), this.hasExactNumberOfChildren(1) ? this.getChild(0).asText() : null, this.getAttribute("label"), this.getAttribute("title"));
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "required": 
            case "placeholder": 
            case "minlength": 
            case "maxlength": 
            case "masked": 
            case "pattern": 
            case "pattern-error-message": 
            case "label": 
            case "title": 
            case "disabled": 
            case "readonly": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "id": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                break;
            }
            case "auto-submit": {
                this.setAttribute(AUTO_SUBMIT_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    private void buildAllFromPresentationML(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException {
        NamedNodeMap attr = element.getAttributes();
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have child elements or text content");
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            this.buildAttributeFromPresentationML(parser, attr.item(i));
        }
    }

    private void buildAttributeFromPresentationML(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "required": 
            case "placeholder": 
            case "minlength": 
            case "maxlength": 
            case "label": 
            case "pattern": 
            case "data-pattern-error-message": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "value": {
                this.addChild(new TextNode((Element)this, this.getStringAttribute(item)));
                break;
            }
            case "data-masked": {
                this.setAttribute(MASKED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "id": {
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public Map<String, String> getOtherAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put("type", PRESENTATIONML_INPUT_TYPE);
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PLACEHOLDER_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(REQUIRED_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        if (this.getAttribute(MASKED_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_MASKED_ATTR, this.getAttribute(MASKED_ATTR));
        }
        if (this.getAttribute("minlength") != null) {
            presentationAttrs.put("minlength", this.getAttribute("minlength"));
        }
        if (this.getAttribute("maxlength") != null) {
            presentationAttrs.put("maxlength", this.getAttribute("maxlength"));
        }
        if (this.getAttribute(DISABLED_ATTR) != null) {
            presentationAttrs.put(DISABLED_ATTR, this.getAttribute(DISABLED_ATTR));
        }
        if (this.getAttribute(READONLY_ATTR) != null) {
            presentationAttrs.put(READONLY_ATTR, this.getAttribute(READONLY_ATTR));
        }
        if (this.getAttribute(AUTO_SUBMIT_ATTR) != null) {
            presentationAttrs.put(AUTO_SUBMIT_ATTR, this.getAttribute(AUTO_SUBMIT_ATTR));
        }
        if (this.getChildren() != null && this.getChildren().size() == 1) {
            presentationAttrs.put(VALUE_ATTR, this.getChildren().get(0).asText());
        }
        return presentationAttrs;
    }

    @Override
    public void updateBiContext(BiContext context) {
        HashMap<String, Object> attributesMapBi = new HashMap<String, Object>();
        this.putTypeIfPresent(attributesMapBi);
        this.putOneIfPresent(attributesMapBi, BiFields.TITLE.getValue(), "title");
        this.putOneIfPresent(attributesMapBi, BiFields.PLACEHOLDER.getValue(), PLACEHOLDER_ATTR);
        this.putOneIfPresent(attributesMapBi, BiFields.LABEL.getValue(), "label");
        this.putOneIfPresent(attributesMapBi, BiFields.REQUIRED.getValue(), REQUIRED_ATTR);
        this.computeAndPutValidationProperties(attributesMapBi);
        if (this.hasElementInitialValue()) {
            attributesMapBi.put(BiFields.DEFAULT.getValue(), 1);
        }
        context.addItem(new BiItem(BiFields.TEXT_FIELD.getValue(), attributesMapBi));
    }

    @Override
    public String getPresentationMLTag() {
        return "input";
    }

    @Override
    public boolean areNestedElementsAllowed() {
        return false;
    }

    @Override
    public String getElementId() {
        return ELEMENT_ID;
    }

    @Override
    public String getElementType() {
        return MESSAGEML_TAG;
    }

    @Override
    public boolean hasElementInitialValue() {
        return this.getChildren() != null && this.getChildren().size() == 1 && this.getChild(0) instanceof TextNode;
    }

    @Override
    public String getElementInitialValue() {
        return ((TextNode)this.getChild(0)).getText();
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return this.getAttribute(attributeName);
    }

    @Override
    public Integer getMinValueAllowed() {
        return MIN_ALLOWED_LENGTH;
    }

    @Override
    public Integer getMaxValueAllowed() {
        return MAX_ALLOWED_LENGTH;
    }

    private void putTypeIfPresent(Map<String, Object> attributesMap) {
        String value = this.getAttributes().get(MASKED_ATTR);
        if (value != null && Boolean.TRUE.equals(Boolean.valueOf(value))) {
            attributesMap.put(BiFields.TYPE.getValue(), BiFields.TYPE_MASKED_TRUE.getValue());
        } else if (value != null && Boolean.FALSE.equals(Boolean.valueOf(value))) {
            attributesMap.put(BiFields.TYPE.getValue(), BiFields.TYPE_MASKED_FALSE.getValue());
        }
    }

    private void computeAndPutValidationProperties(Map<String, Object> attributesMapBi) {
        boolean hasValidation;
        boolean validationMin = this.getAttribute("minlength") != null;
        boolean validationMax = this.getAttribute("maxlength") != null;
        boolean validationPattern = this.getAttribute("pattern") != null;
        boolean bl = hasValidation = validationMin || validationMax || validationPattern;
        if (validationMin) {
            attributesMapBi.put(BiFields.VALIDATION_MIN.getValue(), 1);
        }
        if (validationMax) {
            attributesMapBi.put(BiFields.VALIDATION_MAX.getValue(), 1);
        }
        if (validationPattern) {
            attributesMapBi.put(BiFields.VALIDATION_PATTERN.getValue(), 1);
        }
        if (hasValidation) {
            attributesMapBi.put(BiFields.VALIDATION.getValue(), 1);
        }
    }
}

