/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.TimePickerNode;
import org.symphonyoss.symphony.messageml.util.XMLAttribute;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.symphonyoss.symphony.messageml.util.pojo.TimeInterval;

public class TimePicker
extends FormElement
implements LabelableElement,
TooltipableElement {
    public static final String MESSAGEML_TAG = "time-picker";
    public static final String PRESENTATIONML_INPUT_TYPE = "time";
    private static final String PRESENTATIONML_TAG = "input";
    private static final String VALUE_ATTR = "value";
    private static final String REQUIRED_ATTR = "required";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String MIN_ATTR = "min";
    private static final String MAX_ATTR = "max";
    private static final String DISABLED_TIME_ATTR = "disabled-time";
    private static final String STEP_ATTR = "step";
    private static final String STRICT_ATTR = "strict";
    private static final String FORMAT_ATTR = "format";
    private static final String DISABLED_ATTR = "disabled";
    private static final String READONLY_ATTR = "readonly";
    private static final String PRESENTATIONML_FORMAT_ATTR = "data-format";
    private static final String PRESENTATIONML_DISABLED_TIME_ATTR = "data-disabled-time";
    private static final String PRESENTATIONML_STRICT_ATTR = "data-strict";
    private static final int DISABLED_TIME_RANGE_MAX_LENGTH = 1024;
    private static final int DEFAULT_MAX_LENGTH = 64;
    private static final int MIN_STEP_ALLOWED = 600;
    private static final int MAX_STEP_ALLOWED = 43200;
    private static final String FORMAT_ATTR_PATTERN = "^[hHmsa: ]+$";
    private static final String TIME_FORMAT_ALLOWED = "HH:mm:ss";

    public TimePicker(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "title": 
            case "label": 
            case "value": 
            case "strict": 
            case "required": 
            case "placeholder": 
            case "min": 
            case "max": 
            case "step": 
            case "disabled": 
            case "readonly": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "disabled-time": 
            case "format": {
                if (this.format != FormatEnum.MESSAGEML) {
                    this.throwInvalidInputException(item);
                }
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "type": 
            case "id": 
            case "data-disabled-time": 
            case "data-strict": 
            case "data-format": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        this.assertAttributeNotBlank("name");
        this.assertAttributeMaxLength("name", 64);
        this.assertAttributeMaxLength(PLACEHOLDER_ATTR, 64);
        this.assertAttrDisabledTime();
        this.assertAttrStepRange();
        this.assertAttrFormat();
        this.assertTimeFormat(MIN_ATTR, DateTimeFormatter.ofPattern(TIME_FORMAT_ALLOWED));
        this.assertTimeFormat(MAX_ATTR, DateTimeFormatter.ofPattern(TIME_FORMAT_ALLOWED));
        this.assertTimeFormat(VALUE_ATTR, DateTimeFormatter.ofPattern(TIME_FORMAT_ALLOWED));
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, Arrays.asList("true", "false"));
        }
        if (this.getAttribute(STRICT_ATTR) != null) {
            this.assertAttributeValue(STRICT_ATTR, Arrays.asList("true", "false"));
        }
        if (this.getAttribute(DISABLED_ATTR) != null) {
            this.assertAttributeValue(DISABLED_ATTR, Arrays.asList("true", "false"));
        }
        if (this.getAttribute(READONLY_ATTR) != null) {
            this.assertAttributeValue(READONLY_ATTR, Arrays.asList("true", "false"));
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        Map<String, Object> presentationAttrs = this.buildTimePickerInputAttributes();
        if (this.isSplittable()) {
            presentationAttrs.put("id", this.splittableAsPresentationML(out, context));
            this.innerAsPresentationML(out, presentationAttrs);
            out.closeElement();
        } else {
            this.innerAsPresentationML(out, presentationAttrs);
        }
    }

    @Override
    public Node asMarkdown() {
        return new TimePickerNode(this.getAttribute("label"), this.getAttribute("title"), this.getAttribute(PLACEHOLDER_ATTR));
    }

    @Override
    public void updateBiContext(BiContext context) {
        HashMap<String, Object> attributesMapBi = new HashMap<String, Object>();
        this.putOneIfPresent(attributesMapBi, BiFields.TITLE.getValue(), "title");
        this.putOneIfPresent(attributesMapBi, BiFields.PLACEHOLDER.getValue(), PLACEHOLDER_ATTR);
        this.putOneIfPresent(attributesMapBi, BiFields.LABEL.getValue(), "label");
        this.putOneIfPresent(attributesMapBi, BiFields.REQUIRED.getValue(), REQUIRED_ATTR);
        this.putOneIfPresent(attributesMapBi, BiFields.DEFAULT.getValue(), VALUE_ATTR);
        this.putIntegerIfPresent(attributesMapBi, BiFields.INPUT_STEP.getValue(), STEP_ATTR);
        this.computeAndPutValidationProperties(attributesMapBi);
        context.addItem(new BiItem(BiFields.TIME_PICKER.getValue(), attributesMapBi));
    }

    private void computeAndPutValidationProperties(Map<String, Object> attributesMapBi) {
        boolean hasValidation;
        boolean validationMin = this.getAttribute(MIN_ATTR) != null;
        boolean validationMax = this.getAttribute(MAX_ATTR) != null;
        boolean validationPattern = this.getAttribute(FORMAT_ATTR) != null;
        boolean validationOptions = this.getAttribute(DISABLED_TIME_ATTR) != null;
        boolean validationStrict = this.getAttribute(STRICT_ATTR) != null;
        boolean bl = hasValidation = validationMin || validationMax || validationPattern || validationOptions || validationStrict;
        if (validationMin) {
            attributesMapBi.put(BiFields.VALIDATION_MIN.getValue(), 1);
        }
        if (validationMax) {
            attributesMapBi.put(BiFields.VALIDATION_MAX.getValue(), 1);
        }
        if (validationPattern) {
            attributesMapBi.put(BiFields.VALIDATION_PATTERN.getValue(), 1);
        }
        if (validationOptions) {
            attributesMapBi.put(BiFields.VALIDATION_OPTIONS.getValue(), 1);
        }
        if (validationStrict) {
            attributesMapBi.put(BiFields.VALIDATION_STRICT.getValue(), 1);
        }
        if (hasValidation) {
            attributesMapBi.put(BiFields.VALIDATION.getValue(), 1);
        }
    }

    private void innerAsPresentationML(XmlPrintStream out, Map<String, Object> presentationAttrs) {
        out.printElement(PRESENTATIONML_TAG, presentationAttrs);
    }

    private void assertAttrDisabledTime() throws InvalidInputException {
        String disabledTime = this.getAttribute(DISABLED_TIME_ATTR);
        if (disabledTime == null) {
            return;
        }
        if (disabledTime.length() > 1024) {
            throw new InvalidInputException(String.format("Attribute \"%s\" exceed maximum allowed length (%d)", DISABLED_TIME_ATTR, 1024));
        }
        try {
            TimeInterval[] timeIntervals;
            for (TimeInterval timeInterval : timeIntervals = (TimeInterval[])MAPPER.readValue(disabledTime, TimeInterval[].class)) {
                timeInterval.assertIsValid();
            }
        }
        catch (JsonProcessingException e) {
            throw new InvalidInputException(String.format("Error parsing json in attribute \"%s\": %s", DISABLED_TIME_ATTR, e.getMessage()), e);
        }
    }

    private void assertAttrStepRange() throws InvalidInputException {
        int stepValue;
        String stepAttr = this.getAttribute(STEP_ATTR);
        if (stepAttr == null) {
            return;
        }
        try {
            stepValue = Integer.parseInt(stepAttr);
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException(String.format("Attribute \"%s\" should be a number.", STEP_ATTR));
        }
        if (stepValue < 600 || stepValue > 43200) {
            throw new InvalidInputException(String.format("Attribute \"%s\" must be less than \"%s\" and more than \"%s\".", STEP_ATTR, 43200, 600));
        }
    }

    private void assertAttrFormat() throws InvalidInputException {
        this.assertAttributeMaxLength(FORMAT_ATTR, 64);
        String format = this.getAttribute(FORMAT_ATTR);
        if (format == null) {
            return;
        }
        if (!format.matches(FORMAT_ATTR_PATTERN)) {
            throw new InvalidInputException(String.format("Attribute \"%s\" contains an unsupported time format, only 'h', 'm' 's' and 'a' are supported with ':' or space as separator", FORMAT_ATTR));
        }
        try {
            DateTimeFormatter.ofPattern(format);
        }
        catch (IllegalArgumentException i) {
            throw new InvalidInputException(String.format("Attribute \"%s\" contains an invalid time format", FORMAT_ATTR));
        }
    }

    private Map<String, Object> buildTimePickerInputAttributes() {
        LinkedHashMap<String, Object> presentationAttrs = new LinkedHashMap<String, Object>();
        presentationAttrs.put("type", PRESENTATIONML_INPUT_TYPE);
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(VALUE_ATTR) != null) {
            presentationAttrs.put(VALUE_ATTR, this.getAttribute(VALUE_ATTR));
        }
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PLACEHOLDER_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(MIN_ATTR) != null) {
            presentationAttrs.put(MIN_ATTR, this.getAttribute(MIN_ATTR));
        }
        if (this.getAttribute(MAX_ATTR) != null) {
            presentationAttrs.put(MAX_ATTR, this.getAttribute(MAX_ATTR));
        }
        if (this.getAttribute(STEP_ATTR) != null) {
            presentationAttrs.put(STEP_ATTR, this.getAttribute(STEP_ATTR));
        }
        if (this.getAttribute(FORMAT_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_FORMAT_ATTR, this.getAttribute(FORMAT_ATTR));
        }
        if (this.getAttribute(STRICT_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_STRICT_ATTR, this.getAttribute(STRICT_ATTR));
        }
        if (this.getAttribute(DISABLED_TIME_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_DISABLED_TIME_ATTR, this.convertJsonTimeToPresentationML(DISABLED_TIME_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(REQUIRED_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        if (this.getAttribute(PRESENTATIONML_FORMAT_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_FORMAT_ATTR, this.getAttribute(PRESENTATIONML_FORMAT_ATTR));
        }
        if (this.getAttribute(PRESENTATIONML_STRICT_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_STRICT_ATTR, this.getAttribute(PRESENTATIONML_STRICT_ATTR));
        }
        if (this.getAttribute(PRESENTATIONML_DISABLED_TIME_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_DISABLED_TIME_ATTR, this.getAttribute(PRESENTATIONML_DISABLED_TIME_ATTR));
        }
        if (this.getAttribute(DISABLED_ATTR) != null) {
            presentationAttrs.put(DISABLED_ATTR, this.getAttribute(DISABLED_ATTR));
        }
        if (this.getAttribute(READONLY_ATTR) != null) {
            presentationAttrs.put(READONLY_ATTR, this.getAttribute(READONLY_ATTR));
        }
        return presentationAttrs;
    }

    private XMLAttribute convertJsonTimeToPresentationML(String attributeName) {
        try {
            TimeInterval[] timeIntervals = (TimeInterval[])MAPPER.readValue(this.getAttribute(attributeName), TimeInterval[].class);
            String result = MAPPER.writeValueAsString((Object)timeIntervals);
            return XMLAttribute.of(result, XMLAttribute.Format.JSON);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

