/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.LinkedHashMap;
import java.util.Map;
import org.symphonyoss.symphony.messageml.elements.SplittableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public interface TooltipableElement
extends SplittableElement {
    public static final String TITLE = "title";
    public static final String DATA_TITLE = "data-title";
    public static final String DATA_TARGET_ID = "data-target-id";
    public static final String TOOLTIP_CLASS = "info-hint";
    public static final int TOOLTIP_MAX_LENGTH = 256;
    public static final String TOOLTIP_TOO_LONG_ERR = "The attribute title value is too long. Max length is: %d";
    public static final String TOOLTIPABLE_PRESENTATIONML = "span";

    default public String getPresentationMLTooltipTag() {
        return TOOLTIPABLE_PRESENTATIONML;
    }

    default public Map<String, String> getTooltipAttributes(String id) {
        LinkedHashMap<String, String> spanAttributes = new LinkedHashMap<String, String>();
        spanAttributes.put("class", TOOLTIP_CLASS);
        spanAttributes.put(DATA_TARGET_ID, id);
        spanAttributes.put(DATA_TITLE, this.getAttribute(TITLE));
        return spanAttributes;
    }

    default public boolean isTooltip() {
        return this.getAttribute(TITLE) != null;
    }

    public static boolean isTooltipNode(Node item) {
        if (!TOOLTIPABLE_PRESENTATIONML.equals(item.getNodeName())) {
            return false;
        }
        NamedNodeMap attributes = item.getAttributes();
        return attributes.getNamedItem(DATA_TARGET_ID) != null && attributes.getNamedItem(DATA_TITLE) != null && attributes.getNamedItem("class") != null && TOOLTIP_CLASS.equals(attributes.getNamedItem("class").getNodeValue());
    }

    default public void validateTooltip() throws InvalidInputException {
        String tooltipAttribute = this.getAttribute(TITLE);
        if (tooltipAttribute != null && tooltipAttribute.length() > 256) {
            throw new InvalidInputException(String.format(TOOLTIP_TOO_LONG_ERR, 256));
        }
    }
}

