/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.Button;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Node;

public class UIAction
extends Element {
    public static final String MESSAGEML_TAG = "ui-action";
    private static final String TRIGGER_ATTR = "trigger";
    private static final String ACTION_ATTR = "action";
    private static final String USER_IDS_ATTR = "user-ids";
    private static final String STREAM_ID_ATTR = "stream-id";
    private static final String SIDE_BY_SIDE_ATTR = "side-by-side";
    public static final String TARGET_ID = "target-id";
    private static final String DEFAULT_TRIGGER = "click";
    private static final String OPEN_IM = "open-im";
    private static final String OPEN_DIALOG = "open-dialog";
    private static final List<String> ALLOWED_ACTIONS = Arrays.asList("open-im", "open-dialog");
    private static final int MAX_USER_IDS = 15;
    private static final String PRESENTATIONML_TAG = "div";
    public static final String PRESENTATIONML_CLASS = "ui-action";
    private static final String PRESENTATIONML_ACTION_ATTR = "data-action";
    private static final String PRESENTATIONML_TRIGGER_ATTR = "data-trigger";
    private static final String PRESENTATIONML_USER_IDS_ATTR = "data-user-ids";
    private static final String PRESENTATIONML_STREAM_ID_ATTR = "data-stream-id";
    private static final String PRESENTATIONML_SIDE_BY_SIDE_ATTR = "data-side-by-side";
    private static final String PRESENTATIONML_DATA_TARGET_ID_ATTR = "data-target-id";

    public UIAction(Element parent, FormatEnum format) {
        super(parent, "ui-action", format);
        this.setAttribute(TRIGGER_ATTR, DEFAULT_TRIGGER);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "action": 
            case "data-action": {
                this.setAttribute(ACTION_ATTR, this.getStringAttribute(item));
                break;
            }
            case "trigger": 
            case "data-trigger": {
                this.setAttribute(TRIGGER_ATTR, this.getStringAttribute(item));
                break;
            }
            case "user-ids": 
            case "data-user-ids": {
                this.setAttribute(USER_IDS_ATTR, this.getStringAttribute(item));
                break;
            }
            case "stream-id": 
            case "data-stream-id": {
                this.setAttribute(STREAM_ID_ATTR, this.getStringAttribute(item));
                break;
            }
            case "side-by-side": 
            case "data-side-by-side": {
                this.setAttribute(SIDE_BY_SIDE_ATTR, this.getStringAttribute(item));
                break;
            }
            case "target-id": 
            case "data-target-id": {
                this.setAttribute(TARGET_ID, this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        this.assertUIActionAllowedChildren();
        this.assertAttributeNotBlank(ACTION_ATTR);
        this.assertAttributeValue(ACTION_ATTR, ALLOWED_ACTIONS);
        String actionAttribute = this.getAttribute(ACTION_ATTR);
        if (actionAttribute.equals(OPEN_IM)) {
            this.validateOpenChatActionAttributes();
        } else if (actionAttribute.equals(OPEN_DIALOG)) {
            this.validateIdAttribute(TARGET_ID);
        }
        if (this.getAttribute(TRIGGER_ATTR) != null) {
            this.assertAttributeValue(TRIGGER_ATTR, Collections.singleton(DEFAULT_TRIGGER));
        }
    }

    private void validateOpenChatActionAttributes() throws InvalidInputException {
        if (this.getAttribute(SIDE_BY_SIDE_ATTR) != null) {
            this.assertAttributeIsBoolean(SIDE_BY_SIDE_ATTR);
        }
        if (this.getAttribute(USER_IDS_ATTR) != null && this.getAttribute(STREAM_ID_ATTR) != null) {
            throw new InvalidInputException("Only one between \"stream-id\" and \"user-ids\" is allowed");
        }
        if (this.getAttribute(USER_IDS_ATTR) == null && this.getAttribute(STREAM_ID_ATTR) == null) {
            throw new InvalidInputException("At least one between \"stream-id\" and \"user-ids\" should be present");
        }
        if (this.getAttribute(USER_IDS_ATTR) != null) {
            this.validateUserIdsAttribute();
        }
    }

    private void assertUIActionAllowedChildren() throws InvalidInputException {
        List<Class<? extends Element>> allowedChildren = Arrays.asList(Button.class, UIAction.class);
        this.assertContentModel(allowedChildren);
        this.assertContainsAlwaysChildOfType(allowedChildren);
    }

    @Override
    void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        Map<String, String> presentationAttrs = this.buildAUIActionAttributes();
        out.openElement(this.getPresentationMLTag(), presentationAttrs);
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    @Override
    public String getPresentationMLTag() {
        return PRESENTATIONML_TAG;
    }

    @Override
    void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        String actionAttribute = this.getAttribute(ACTION_ATTR);
        if (actionAttribute != null) {
            switch (actionAttribute) {
                case "open-im": {
                    context.updateItemCount(BiFields.OPENIM.getValue());
                    break;
                }
                case "open-dialog": {
                    context.updateItemCount(BiFields.OPENDIALOG.getValue());
                }
            }
        }
    }

    private void validateUserIdsAttribute() throws InvalidInputException {
        String userIds = this.getAttribute(USER_IDS_ATTR);
        try {
            List userIdsList = (List)MAPPER.readValue(userIds, (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, Long.class));
            if (userIdsList.size() > 15) {
                throw new InvalidInputException("Attribute \"user-ids\" contains more values than allowed. Max value is 15");
            }
        }
        catch (JsonProcessingException e) {
            throw new InvalidInputException("Attribute \"user-ids\" contains an unsupported format, should be an array of user ids");
        }
    }

    private Map<String, String> buildAUIActionAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put("class", "ui-action");
        presentationAttrs.put(PRESENTATIONML_ACTION_ATTR, this.getAttribute(ACTION_ATTR));
        if (this.getAttribute(TRIGGER_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_TRIGGER_ATTR, this.getAttribute(TRIGGER_ATTR));
        }
        if (this.getAttribute(USER_IDS_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_USER_IDS_ATTR, this.getAttribute(USER_IDS_ATTR));
        }
        if (this.getAttribute(STREAM_ID_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_STREAM_ID_ATTR, this.getAttribute(STREAM_ID_ATTR));
        }
        if (this.getAttribute(SIDE_BY_SIDE_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_SIDE_BY_SIDE_ATTR, this.getAttribute(SIDE_BY_SIDE_ATTR));
        }
        if (this.getAttribute(TARGET_ID) != null) {
            presentationAttrs.put(PRESENTATIONML_DATA_TARGET_ID_ATTR, this.getAttribute(TARGET_ID));
        }
        return presentationAttrs;
    }
}

