/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.util.instrument.resolver;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum MarketSector {
    EQUITY("Equity"),
    COMDTY("Comdty"),
    CORP("Corp"),
    CURNCY("Curncy"),
    GOVT("Govt"),
    INDEX("Index"),
    MMKT("Mmkt"),
    MTGE("Mtge"),
    MUNI("Muni"),
    PFD("Pfd");

    private String value;

    private MarketSector(String value) {
        this.value = value;
    }

    @JsonCreator
    public static MarketSector fromValue(String text) {
        for (MarketSector b : MarketSector.values()) {
            if (!String.valueOf(b.value).equals(text)) continue;
            return b;
        }
        return null;
    }

    public static List<String> toValues() {
        return Arrays.asList(MarketSector.values()).stream().map(MarketSector::getValue).collect(Collectors.toList());
    }

    public String getValue() {
        return this.value;
    }
}

