/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Text;

public class TextNode
extends Element {
    private String text;

    public TextNode(Element parent, Text node) {
        this(parent, TextNode.removeNewLines(node.getTextContent()));
    }

    public TextNode(Element parent, String text) {
        super(parent);
        this.text = text;
    }

    private static String removeNewLines(String textContent) {
        if (textContent == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        boolean inNl = false;
        for (char c : textContent.toCharArray()) {
            if (c == '\n') {
                if (inNl) continue;
                s.append(' ');
                inNl = true;
                continue;
            }
            inNl = false;
            s.append(c);
        }
        return s.toString();
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        out.println(out.escape(this.text));
    }

    public void asMarkdown(Node parent) {
        org.commonmark.node.Text node = new org.commonmark.node.Text(this.text);
        parent.appendChild((Node)node);
    }

    @Override
    protected void buildText(Text node) {
        this.text = TextNode.removeNewLines(node.getTextContent());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String asText() {
        return this.text;
    }

    @Override
    public Node asMarkdown() {
        return new org.commonmark.node.Text(this.text);
    }

    public String toString() {
        return "Text(" + this.text + ")";
    }
}

