/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.util;

import java.io.OutputStream;
import java.util.Map;
import java.util.Stack;
import org.symphonyoss.symphony.messageml.util.IndentedPrintStream;

public class XmlPrintStream
extends IndentedPrintStream {
    private final Stack<String> elementStack = new Stack();

    public XmlPrintStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void startElement(String name, String ... attributes) {
        this.println("<" + name);
        this.indent();
        int i = 0;
        while (i < attributes.length) {
            if (i < attributes.length - 1) {
                this.println(" " + attributes[i++] + "=\"" + attributes[i++] + "\"");
                continue;
            }
            this.println(" " + attributes[i++]);
        }
    }

    public void openElement(String name) {
        this.elementStack.push(name);
        this.println("<" + name + ">");
        this.indent();
    }

    public void openElement(String name, Map<String, String> attributes) {
        this.elementStack.push(name);
        this.print("<" + name);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            this.print(" " + entry.getKey() + "=\"" + this.escape(entry.getValue()) + "\"");
        }
        this.println(">");
        this.indent();
    }

    public void openElement(String name, String ... attributes) {
        this.elementStack.push(name);
        this.startElement(name, attributes);
        this.println(">");
    }

    public void closeElement() {
        this.outdent();
        this.println("</" + this.elementStack.pop() + ">");
    }

    public void printElement(String elementName, Object value) {
        this.println("<" + elementName + ">" + (value == null ? "" : this.escape(value.toString())) + "</" + elementName + ">");
    }

    public void printElement(String name, String value, String ... attributes) {
        this.startElement(name, attributes);
        if (value != null) {
            this.println(">" + this.escape(value) + "</" + name + ">");
        } else {
            this.println("/>");
        }
        this.outdent();
    }

    public void printElement(String elementName, String value, Map<String, String> attributes) {
        this.print("<" + elementName);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            this.print(" " + entry.getKey() + "=\"" + this.escape(entry.getValue()) + "\"");
        }
        if (value != null) {
            this.println(">" + this.escape(value) + "</" + elementName + ">");
        } else {
            this.println("/>");
        }
    }

    public void printElement(String name) {
        this.println("<" + name + "/>");
    }

    public void printComment(String comment) {
        this.println("<!-- " + comment + " -->");
    }

    public String escape(String in) {
        StringBuffer out = new StringBuffer();
        block6: for (char c : in.toCharArray()) {
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block6;
                }
                case '>': {
                    out.append("&gt;");
                    continue block6;
                }
                case '&': {
                    out.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }
}

