/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.commonmark.node.Node;
import org.commonmark.node.StrongEmphasis;
import org.symphonyoss.symphony.messageml.elements.Bold;
import org.symphonyoss.symphony.messageml.elements.Chime;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Image;
import org.symphonyoss.symphony.messageml.elements.Italic;
import org.symphonyoss.symphony.messageml.elements.LineBreak;
import org.symphonyoss.symphony.messageml.elements.Link;
import org.symphonyoss.symphony.messageml.elements.Span;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;

public class Header
extends Element {
    private static final Pattern PATTERN = Pattern.compile("^h([1-6])$");
    public static final String MESSAGEML_TAG = "h";
    private static final String MARKDOWN = "**";

    public Header(Element parent, String tag) {
        super(parent, tag);
    }

    @Override
    public Node asMarkdown() {
        return new StrongEmphasis(MARKDOWN);
    }

    public static boolean isHeaderElement(String tag) {
        return PATTERN.matcher(tag).matches();
    }

    @Override
    public void validate() throws InvalidInputException {
        this.assertContentModel(Arrays.asList(TextNode.class, Link.class, Chime.class, Bold.class, Italic.class, Image.class, LineBreak.class, Span.class));
    }
}

