/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Form;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.ButtonNode;

public class Button
extends Element {
    public static final String MESSAGEML_TAG = "button";
    public static final String ID_ATTR = "id";
    public static final String TYPE_ATTR = "type";
    public static final Set<String> VALID_CLASSES = new HashSet<String>(Arrays.asList("primary", "secondary", "primary-destructive", "secondary-destructive"));
    public static final Set<String> VALID_TYPES = new HashSet<String>(Arrays.asList("action", "reset"));

    public Button(Element parent) {
        super(parent, MESSAGEML_TAG);
        this.setAttribute(TYPE_ATTR, "action");
    }

    @Override
    public void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "id": {
                this.setAttribute(ID_ATTR, this.getStringAttribute(item).toLowerCase());
                break;
            }
            case "type": {
                this.setAttribute(TYPE_ATTR, this.getStringAttribute(item).toLowerCase());
                break;
            }
            case "class": {
                this.setAttribute("class", this.getStringAttribute(item).toLowerCase());
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new ButtonNode();
    }

    @Override
    public void validate() throws InvalidInputException {
        String type = this.getAttribute(TYPE_ATTR);
        String id = this.getAttribute(ID_ATTR);
        String clazz = this.getAttribute("class");
        if (this.getParent().getClass() != Form.class) {
            throw new InvalidInputException("A \"button\" element can only be a child of a \"form\" element");
        }
        if (!VALID_TYPES.contains(type)) {
            throw new InvalidInputException("Attribute \"type\" must be \"action\" or \"reset\"");
        }
        if (clazz != null && !VALID_CLASSES.contains(clazz)) {
            throw new InvalidInputException("Attribute \"class\" must be \"primary\", \"secondary\", \"primary-destructive\" or \"secondary-destructive\"");
        }
        if (type.equals("action") && StringUtils.isBlank((CharSequence)id)) {
            throw new InvalidInputException("Attribute \"id\" is required for generic action buttons");
        }
        this.assertContentModel(Collections.singleton(TextNode.class));
    }
}

