/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Collections;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.Select;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.OptionNode;

public class Option
extends FormElement {
    public static final String MESSAGEML_TAG = "option";
    public static final String VALUE_ATTR = "value";

    public Option(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    public Node asMarkdown() {
        return new OptionNode();
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.getAttribute(VALUE_ATTR) == null) {
            throw new InvalidInputException("The attribute \"value\" is required");
        }
        this.assertParent(Collections.singleton(Select.class));
        this.assertContentModel(Collections.singleton(TextNode.class));
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        if (!item.getNodeName().equals(VALUE_ATTR)) {
            throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
        }
        this.setAttribute(VALUE_ATTR, this.getStringAttribute(item));
    }
}

