/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.Option;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.SelectNode;

public class Select
extends FormElement {
    public static final String MESSAGEML_TAG = "select";
    private static final String NAME_ATTR = "name";
    private static final String REQUIRED_ATTR = "required";
    private static final Set<String> VALID_VALUES_FOR_REQUIRED_ATTR = new HashSet<String>(Arrays.asList("true", "false"));

    public Select(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    public Node asMarkdown() {
        return new SelectNode(this.getAttribute(NAME_ATTR));
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute(NAME_ATTR) == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        this.assertContentModel(Collections.singleton(Option.class));
        this.assertAtLeastOneOptionChild();
        this.validateRequiredAttribute(this.getAttribute(REQUIRED_ATTR));
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute(NAME_ATTR, this.getStringAttribute(item));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    private void assertAtLeastOneOptionChild() throws InvalidInputException {
        boolean hasOptionElementAsChild = this.getChildren().stream().anyMatch(child -> child.getClass().equals(Option.class));
        if (!hasOptionElementAsChild) {
            throw new InvalidInputException(String.format("The \"%s\" element must have at least one \"%s\" as its child.", MESSAGEML_TAG, "option"));
        }
    }

    private void validateRequiredAttribute(String requiredAttrValue) throws InvalidInputException {
        if (requiredAttrValue != null && !VALID_VALUES_FOR_REQUIRED_ATTR.contains(requiredAttrValue)) {
            throw new InvalidInputException(String.format("Attribute \"%s\" must have one of the following values: %s", REQUIRED_ATTR, VALID_VALUES_FOR_REQUIRED_ATTR));
        }
    }
}

