/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.FormElementNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Password
extends FormElement {
    public static final String MESSAGEML_TAG = "password";
    public static final String PRESENTATIONML_INPUT_TYPE = "password";
    private static final String MINLENGTH_ATTR = "minlength";
    private static final String MAXLENGTH_ATTR = "maxlength";
    private static final String REQUIRED_ATTR = "required";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String VALUE_ATTR = "value";
    private static final List<String> VALID_VALUES_FOR_REQUIRED_ATTR = Arrays.asList("true", "false");
    private static final String MARKDOWN = "Password Field";
    private static final String PRESENTATIONML_INPUT_TAG = "input";
    private static final String PRESENTATIONML_TYPE_ATTR = "type";
    private static final int MIN_ALLOWED_LENGTH = 1;
    private static final int MAX_ALLOWED_LENGTH = 128;

    public Password(Element parent, FormatEnum format) {
        super(parent, "password", format);
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_VALUES_FOR_REQUIRED_ATTR);
        }
        this.validateMinAndMaxLengths();
        this.assertContentModel(Collections.singleton(TextNode.class));
    }

    @Override
    public void buildAll(MessageMLParser context, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(context, element);
                break;
            }
            case PRESENTATIONML: {
                this.buildAllForPresentationML(element);
            }
        }
    }

    private void buildAllForPresentationML(org.w3c.dom.Element element) throws InvalidInputException {
        NamedNodeMap attr = element.getAttributes();
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have child elements or text content");
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            this.buildAttributeForPresentationML(attr.item(i));
        }
    }

    private void buildAttributeForPresentationML(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "placeholder": {
                this.setAttribute(PLACEHOLDER_ATTR, this.getStringAttribute(item));
                break;
            }
            case "minlength": {
                this.setAttribute(MINLENGTH_ATTR, this.getStringAttribute(item));
                break;
            }
            case "maxlength": {
                this.setAttribute(MAXLENGTH_ATTR, this.getStringAttribute(item));
                break;
            }
            case "value": {
                this.addChild(new TextNode((Element)this, this.getStringAttribute(item)));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "placeholder": {
                this.setAttribute(PLACEHOLDER_ATTR, this.getStringAttribute(item));
                break;
            }
            case "minlength": {
                this.setAttribute(MINLENGTH_ATTR, this.getStringAttribute(item));
                break;
            }
            case "maxlength": {
                this.setAttribute(MAXLENGTH_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        Map<String, String> presentationAttrs = this.buildTextFieldInputAttributes();
        out.printElement(PRESENTATIONML_INPUT_TAG, presentationAttrs);
    }

    @Override
    public Node asMarkdown() {
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            return new FormElementNode(MARKDOWN, ":" + this.getAttribute(PLACEHOLDER_ATTR));
        }
        return new FormElementNode(MARKDOWN);
    }

    private Map<String, String> buildTextFieldInputAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put(PRESENTATIONML_TYPE_ATTR, "password");
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PLACEHOLDER_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(REQUIRED_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        if (this.getAttribute(MINLENGTH_ATTR) != null) {
            presentationAttrs.put(MINLENGTH_ATTR, this.getAttribute(MINLENGTH_ATTR));
        }
        if (this.getAttribute(MAXLENGTH_ATTR) != null) {
            presentationAttrs.put(MAXLENGTH_ATTR, this.getAttribute(MAXLENGTH_ATTR));
        }
        if (this.getChildren() != null && this.getChildren().size() == 1) {
            presentationAttrs.put(VALUE_ATTR, this.getChildren().get(0).asText());
        }
        return presentationAttrs;
    }

    private void validateMinAndMaxLengths() throws InvalidInputException {
        int maxLength = this.getLengthAttributeAsInt(MAXLENGTH_ATTR);
        if (this.isLengthIsOutOfRange(maxLength)) {
            throw new InvalidInputException(this.getLengthErrorMessage(MAXLENGTH_ATTR));
        }
        int minLength = this.getLengthAttributeAsInt(MINLENGTH_ATTR);
        if (this.isLengthIsOutOfRange(minLength)) {
            throw new InvalidInputException(this.getLengthErrorMessage(MINLENGTH_ATTR));
        }
        if (minLength > maxLength) {
            throw new InvalidInputException("The attribute \"minlength\" must be lower than the \"maxlength\" attribute");
        }
    }

    private int getLengthAttributeAsInt(String attributeName) throws InvalidInputException {
        int length = 1;
        if (this.getAttribute(attributeName) != null) {
            try {
                length = Integer.parseInt(this.getAttribute(attributeName));
            }
            catch (NumberFormatException e) {
                throw new InvalidInputException(this.getLengthErrorMessage(attributeName));
            }
        }
        return length;
    }

    private boolean isLengthIsOutOfRange(int length) {
        return length < 1 || length > 128;
    }

    private String getLengthErrorMessage(String attributeName) {
        return String.format("The attribute \"" + attributeName + "\" must be between %s and %s", 1, 128);
    }
}

