/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.FormElementNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class TextField
extends FormElement {
    public static final String MESSAGEML_TAG = "text-field";
    public static final String PRESENTATIONML_INPUT_TYPE = "text";
    private static final String REQUIRED_ATTR = "required";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String VALUE_ATTR = "value";
    private static final Set<String> VALID_VALUES_FOR_REQUIRED_ATTR = new HashSet<String>(Arrays.asList("true", "false"));
    private static final String MARKDOWN = "Text Field";

    public TextField(Element parent, FormatEnum messageFormat) {
        super(parent, MESSAGEML_TAG, messageFormat);
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_VALUES_FOR_REQUIRED_ATTR);
        }
        this.assertContentModel(Collections.singleton(TextNode.class));
    }

    @Override
    public void buildAll(MessageMLParser context, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(context, element);
                break;
            }
            case PRESENTATIONML: {
                this.buildAllForPresentationML(element);
            }
        }
    }

    private void buildAllForPresentationML(org.w3c.dom.Element element) throws InvalidInputException {
        NamedNodeMap attr = element.getAttributes();
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have child elements or text content");
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            this.buildAttributeForPresentationML(attr.item(i));
        }
    }

    private void buildAttributeForPresentationML(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "value": {
                this.addChild(new TextNode((Element)this, this.getStringAttribute(item)));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "placeholder": {
                this.setAttribute(PLACEHOLDER_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "placeholder": {
                this.setAttribute(PLACEHOLDER_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        Map<String, String> presentationAttrs = this.buildTextFieldInputAttributes();
        out.printElement("input", presentationAttrs);
    }

    @Override
    public Node asMarkdown() {
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            return new FormElementNode(MARKDOWN, ":" + this.getAttribute(PLACEHOLDER_ATTR));
        }
        return new FormElementNode(MARKDOWN);
    }

    private Map<String, String> buildTextFieldInputAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put("type", PRESENTATIONML_INPUT_TYPE);
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PLACEHOLDER_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(REQUIRED_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        if (this.getChildren() != null && this.getChildren().size() == 1) {
            presentationAttrs.put(VALUE_ATTR, this.getChildren().get(0).asText());
        }
        return presentationAttrs;
    }
}

