/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Bold;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.Italic;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.FormElementNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Checkbox
extends FormElement {
    public static final String MESSAGEML_TAG = "checkbox";
    public static final String PRESENTATIONML_INPUT_TYPE = "checkbox";
    public static final String PRESENTATIONML_DIV_CLASS = "checkbox-group";
    private static final String VALUE_ATTR = "value";
    private static final String CHECKED_ATTR = "checked";
    private static final String PRESENTATIONML_DIV_TAG = "div";
    private static final String PRESENTATIONML_CLASS_ATTR = "class";
    private static final String PRESENTATIONML_DEFAULT_CHECKBOX_VALUE = "on";
    private static final String PRESENTATIONML_LABEL_TAG = "label";
    private static final int PRESENTATIONML_DIV_NUMBER_OF_CHILDREN = 2;
    private static final String MARKDOWN = "Checkbox:";

    public Checkbox(Element parent, FormatEnum messageFormat) {
        super(parent, "checkbox", messageFormat);
    }

    @Override
    public void buildAll(MessageMLParser context, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(context, element);
                break;
            }
            case PRESENTATIONML: {
                if ("input".equals(element.getNodeName())) {
                    this.buildCheckboxAttrFromInputTag(element);
                } else {
                    this.buildElementFromGroupDiv(context, element);
                }
                this.validate();
                break;
            }
            default: {
                throw new InvalidInputException(String.format("Invalid message format for \"%s\" element", "checkbox"));
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(CHECKED_ATTR) != null) {
            this.assertAttributeValue(CHECKED_ATTR, Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (!this.getChildren().isEmpty()) {
            this.assertContentModel(Arrays.asList(TextNode.class, Bold.class, Italic.class));
        }
        this.assertAttributeNotBlank("name");
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "value": {
                this.setAttribute(VALUE_ATTR, this.getStringAttribute(item));
                break;
            }
            case "checked": {
                this.setAttribute(CHECKED_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        Map<String, String> presentationAttrs = this.buildCheckboxInputAttributes();
        if (this.getChildren().isEmpty()) {
            out.printElement("input", presentationAttrs);
        } else {
            out.openElement(PRESENTATIONML_DIV_TAG, PRESENTATIONML_CLASS_ATTR, PRESENTATIONML_DIV_CLASS);
            out.printElement("input", presentationAttrs);
            out.openElement(PRESENTATIONML_LABEL_TAG);
            for (Element child : this.getChildren()) {
                child.asPresentationML(out);
            }
            out.closeElement();
            out.closeElement();
        }
    }

    @Override
    public Node asMarkdown() {
        return new FormElementNode(MARKDOWN, this.getAttribute("name"));
    }

    private void buildElementFromGroupDiv(MessageMLParser context, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        NodeList children = element.getChildNodes();
        Integer numberOfNonTextChildrenNodes = this.countNonTextNodesInNodeList(children);
        if (numberOfNonTextChildrenNodes != 2) {
            throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", "checkbox"));
        }
        String firstNodeName = "";
        block10: for (int i = 0; i < children.getLength(); ++i) {
            if (firstNodeName.equals(children.item(i).getNodeName())) {
                throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", "checkbox"));
            }
            switch (children.item(i).getNodeName()) {
                case "input": {
                    this.buildCheckboxAttrFromInputTag(children.item(i));
                    firstNodeName = "input";
                    continue block10;
                }
                case "label": {
                    this.buildCheckboxTextFromLabelTag(context, children.item(i));
                    firstNodeName = PRESENTATIONML_LABEL_TAG;
                    continue block10;
                }
                case "#text": {
                    continue block10;
                }
                default: {
                    throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", "checkbox"));
                }
            }
        }
    }

    private void buildCheckboxTextFromLabelTag(MessageMLParser context, org.w3c.dom.Node labelElement) throws InvalidInputException, ProcessingException {
        NodeList childNodes = labelElement.getChildNodes();
        if (childNodes == null || childNodes.getLength() <= 0) {
            throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", "checkbox"));
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            this.buildNode(context, childNodes.item(i));
        }
    }

    private void buildCheckboxAttrFromInputTag(org.w3c.dom.Node inputElement) throws InvalidInputException {
        NamedNodeMap inputAttributes = inputElement.getAttributes();
        inputAttributes.removeNamedItem("type");
        for (int i = 0; i < inputAttributes.getLength(); ++i) {
            this.buildAttribute(inputAttributes.item(i));
        }
    }

    private Map<String, String> buildCheckboxInputAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put("type", "checkbox");
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(CHECKED_ATTR) != null) {
            presentationAttrs.put(CHECKED_ATTR, this.getAttribute(CHECKED_ATTR));
        }
        if (this.getAttribute(VALUE_ATTR) != null) {
            presentationAttrs.put(VALUE_ATTR, this.getAttribute(VALUE_ATTR));
        } else {
            presentationAttrs.put(VALUE_ATTR, PRESENTATIONML_DEFAULT_CHECKBOX_VALUE);
        }
        return presentationAttrs;
    }
}

