/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.FormElementNode;

public class TextArea
extends FormElement {
    public static final String MESSAGEML_TAG = "textarea";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String REQUIRED_ATTR = "required";
    private static final List<String> VALID_VALUES_FOR_REQUIRED_ATTR = Arrays.asList("true", "false");
    private static final String MARKDOWN = "Text Area";

    public TextArea(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_VALUES_FOR_REQUIRED_ATTR);
        }
        this.assertAttributeNotBlank("name");
        this.assertContentModel(Collections.singleton(TextNode.class));
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "placeholder": {
                this.setAttribute(PLACEHOLDER_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    public Node asMarkdown() {
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            return new FormElementNode(MARKDOWN, ":" + this.getAttribute(PLACEHOLDER_ATTR));
        }
        return new FormElementNode(MARKDOWN);
    }
}

