/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.ButtonNode;

public class Button
extends FormElement {
    public static final String MESSAGEML_TAG = "button";
    public static final String ACTION_TYPE = "action";
    public static final String RESET_TYPE = "reset";
    private static final Set<String> VALID_CLASSES = new HashSet<String>(Arrays.asList("primary", "secondary", "primary-destructive", "secondary-destructive"));
    private static final Set<String> VALID_TYPES = new HashSet<String>(Arrays.asList("action", "reset"));

    public Button(Element parent) {
        super(parent, MESSAGEML_TAG);
        this.setAttribute("type", ACTION_TYPE);
    }

    @Override
    public void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "type": {
                this.setAttribute("type", this.getStringAttribute(item));
                break;
            }
            case "class": {
                this.setAttribute("class", this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new ButtonNode();
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        String type = this.getAttribute("type");
        String name = this.getAttribute("name");
        String clazz = this.getAttribute("class");
        if (!VALID_TYPES.contains(type)) {
            throw new InvalidInputException("Attribute \"type\" must be \"action\" or \"reset\"");
        }
        if (clazz != null && !VALID_CLASSES.contains(clazz)) {
            throw new InvalidInputException("Attribute \"class\" must be \"primary\", \"secondary\", \"primary-destructive\" or \"secondary-destructive\"");
        }
        if (type.equals(ACTION_TYPE) && StringUtils.isBlank((CharSequence)name)) {
            throw new InvalidInputException("Attribute \"name\" is required for action buttons");
        }
        if (type.equals(RESET_TYPE) && this.getAttributes().containsKey("name")) {
            throw new InvalidInputException("Attribute \"name\" is allowed for action buttons only");
        }
        this.assertContentModel(Collections.singleton(TextNode.class));
        this.assertContainsChildOfType(Collections.singleton(TextNode.class));
    }
}

