/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Collections;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class CardHeader
extends Element {
    public static final String MESSAGEML_TAG = "header";
    public static final String PRESENTATIONML_CLASS = "cardHeader";
    private static final String PRESENTATIONML_TAG = "div";

    public CardHeader(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
    }

    @Override
    void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        out.openElement(PRESENTATIONML_TAG, Collections.singletonMap("class", PRESENTATIONML_CLASS));
        for (Element child : this.getChildren()) {
            child.asPresentationML(out);
        }
        out.closeElement();
    }

    @Override
    public Node asMarkdown() {
        return new Paragraph();
    }

    @Override
    void validate() throws InvalidInputException {
        this.assertNoAttributes();
    }

    @Override
    public String getPresentationMLTag() {
        return PRESENTATIONML_TAG;
    }
}

