/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;

public interface RegexElement {
    public static final String PATTERN_ATTR = "pattern";
    public static final String PATTERN_ERROR_MESSAGE_ATTR = "pattern-error-message";
    public static final String PRESENTATIONML_PATTERN_ERROR_MESSAGE_ATTR = "data-pattern-error-message";
    public static final List<String> ALL_REGEX_ATTRS = Arrays.asList("pattern", "pattern-error-message", "data-pattern-error-message");
    public static final int PATTERN_MAX_LENGTH = 256;
    public static final int PATTERN_ERROR_MESSAGE_MAX_LENGTH = 256;
    public static final String ATTRIBUTE_MANDATORY_WHEN_ATTRIBUTE_DEFINED_ERR = "The attribute \"%s\" is mandatory when attribute \"%s\" is defined";
    public static final String ATTRIBUTE_TOO_LONG_ERR = "The attribute \"%s\" value is too long. Max length for this attribute is: %d";
    public static final String REGEX_NOT_VALID_ERR = "The regex \"%s\" is not valid";

    default public void validateRegex() throws InvalidInputException {
        String regexPattern = this.getAttribute(PATTERN_ATTR);
        if (regexPattern != null) {
            String regexPatterErrorMessage = this.getAttribute(PATTERN_ERROR_MESSAGE_ATTR);
            if (regexPatterErrorMessage == null) {
                throw new InvalidInputException(String.format(ATTRIBUTE_MANDATORY_WHEN_ATTRIBUTE_DEFINED_ERR, PATTERN_ERROR_MESSAGE_ATTR, PATTERN_ATTR));
            }
            if (regexPattern.length() > 256) {
                throw new InvalidInputException(String.format(ATTRIBUTE_TOO_LONG_ERR, PATTERN_ATTR, 256));
            }
            if (regexPatterErrorMessage.length() > 256) {
                throw new InvalidInputException(String.format(ATTRIBUTE_TOO_LONG_ERR, PATTERN_ERROR_MESSAGE_ATTR, 256));
            }
            try {
                Pattern.compile(regexPattern);
            }
            catch (PatternSyntaxException p) {
                throw new InvalidInputException(String.format(REGEX_NOT_VALID_ERR, regexPattern), p);
            }
        }
    }

    default public Map<String, String> getRegexAttrForPresentationML() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        if (this.getAttribute(PATTERN_ATTR) != null) {
            presentationAttrs.put(PATTERN_ATTR, this.getAttribute(PATTERN_ATTR));
        }
        if (this.getAttribute(PATTERN_ERROR_MESSAGE_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_PATTERN_ERROR_MESSAGE_ATTR, this.getAttribute(PATTERN_ERROR_MESSAGE_ATTR));
        }
        return presentationAttrs;
    }

    default public Map<String, String> getOtherAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>(this.getAttributes());
        ALL_REGEX_ATTRS.stream().forEach(attr -> {
            String cfr_ignored_0 = (String)presentationAttrs.remove(attr);
        });
        return presentationAttrs;
    }

    public String getAttribute(String var1);

    public Map<String, String> getAttributes();
}

