/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Code;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.TextArea;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Text;

public class TextNode
extends Element {
    private String text;

    public TextNode(Element parent, Text node) {
        this(parent, node.getTextContent());
    }

    public TextNode(Element parent, String text) {
        super(parent);
        this.text = text;
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        String content = this.text;
        if (out.isRemoveNl() && !(this.getParent() instanceof Code) && !(this.getParent() instanceof TextArea)) {
            content = XmlPrintStream.removeNewLines(content);
        }
        content = out.escape(content);
        out.println(content);
    }

    @Override
    public Node asMarkdown() {
        return new org.commonmark.node.Text(this.text);
    }

    @Override
    protected void buildText(Text node) {
        this.text = node.getTextContent();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String asText() {
        return this.text;
    }

    public String toString() {
        return "Text(" + this.text + ")";
    }
}

