/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.LinkedHashMap;
import java.util.Map;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class GroupedElement
extends FormElement {
    private static final String PRESENTATIONML_DIV_TAG = "div";
    private static final String PRESENTATIONML_CLASS_ATTR = "class";
    private static final int PRESENTATIONML_DIV_NUMBER_OF_CHILDREN = 2;
    private static final String PRESENTATIONML_DEFAULT_VALUE = "on";
    protected static final String PRESENTATIONML_LABEL_TAG = "label";
    protected static final String VALUE_ATTR = "value";
    protected static final String CHECKED_ATTR = "checked";

    public GroupedElement(Element parent, String messageMLTag, FormatEnum format) {
        super(parent, messageMLTag, format);
    }

    @Override
    public void buildAll(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(parser, element);
                break;
            }
            case PRESENTATIONML: {
                if ("input".equals(element.getNodeName())) {
                    this.buildElementAttrFromInputTag(parser, element);
                } else {
                    this.buildElementFromGroupDiv(parser, element);
                }
                this.validate();
                break;
            }
            default: {
                throw new InvalidInputException(String.format("Invalid message format for \"%s\" element", this.getMessageMLTag()));
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        Map<String, String> presentationAttrs = this.buildGroupedElementInputAttributes();
        if (this.getChildren().isEmpty()) {
            out.printElement("input", presentationAttrs);
        } else {
            out.openElement(PRESENTATIONML_DIV_TAG, PRESENTATIONML_CLASS_ATTR, this.getPresentationMLDivClass());
            out.printElement("input", presentationAttrs);
            out.openElement(PRESENTATIONML_LABEL_TAG);
            for (Element child : this.getChildren()) {
                child.asPresentationML(out, context);
            }
            out.closeElement();
            out.closeElement();
        }
    }

    protected void buildElementFromGroupDiv(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        NodeList children = element.getChildNodes();
        Integer numberOfNonTextChildrenNodes = this.countNonTextNodesInNodeList(children);
        if (numberOfNonTextChildrenNodes != 2) {
            throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", this.getMessageMLTag()));
        }
        String firstNodeName = "";
        block10: for (int i = 0; i < children.getLength(); ++i) {
            if (firstNodeName.equals(children.item(i).getNodeName())) {
                throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", this.getMessageMLTag()));
            }
            switch (children.item(i).getNodeName()) {
                case "input": {
                    this.buildElementAttrFromInputTag(parser, children.item(i));
                    firstNodeName = "input";
                    continue block10;
                }
                case "label": {
                    this.buildTextFromLabelTag(parser, children.item(i));
                    firstNodeName = PRESENTATIONML_LABEL_TAG;
                    continue block10;
                }
                case "#text": {
                    continue block10;
                }
                default: {
                    throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", this.getMessageMLTag()));
                }
            }
        }
    }

    private void buildTextFromLabelTag(MessageMLParser context, Node labelElement) throws InvalidInputException, ProcessingException {
        NodeList childNodes = labelElement.getChildNodes();
        if (childNodes == null || childNodes.getLength() <= 0) {
            throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", this.getMessageMLTag()));
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            this.buildNode(context, childNodes.item(i));
        }
    }

    protected void buildElementAttrFromInputTag(MessageMLParser parser, Node inputElement) throws InvalidInputException {
        NamedNodeMap inputAttributes = inputElement.getAttributes();
        inputAttributes.removeNamedItem("type");
        for (int i = 0; i < inputAttributes.getLength(); ++i) {
            this.buildAttribute(parser, inputAttributes.item(i));
        }
    }

    protected Map<String, String> buildGroupedElementInputAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put("type", this.getPresentationMLInputType());
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(CHECKED_ATTR) != null) {
            presentationAttrs.put(CHECKED_ATTR, this.getAttribute(CHECKED_ATTR));
        }
        if (this.getAttribute(VALUE_ATTR) != null) {
            presentationAttrs.put(VALUE_ATTR, this.getAttribute(VALUE_ATTR));
        } else {
            presentationAttrs.put(VALUE_ATTR, PRESENTATIONML_DEFAULT_VALUE);
        }
        return presentationAttrs;
    }

    protected abstract String getPresentationMLInputType();

    protected abstract String getPresentationMLDivClass();
}

