/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public interface LabelableElement {
    public static final String LABEL = "label";
    public static final String LABEL_FOR = "for";
    public static final int LABEL_MAX_LENGTH = 256;
    public static final String LABEL_TOO_LONG_ERR = "The attribute label value is too long. Max length is: %d";

    default public String getPresentationMLLabelTag() {
        return LABEL;
    }

    default public Map<String, String> getLabelAttribute(String id) {
        HashMap<String, String> labelAttributes = new HashMap<String, String>();
        labelAttributes.put(LABEL_FOR, id);
        return labelAttributes;
    }

    default public String getElementId() {
        if (this instanceof Element) {
            return ((Element)((Object)this)).getPresentationMLTag();
        }
        return "";
    }

    default public String labelAsPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.openElement("div", Collections.singletonMap("class", String.format("%s-group", this.getElementId())));
        String id = String.format("%s-%s", this.getElementId(), context.generateShortId());
        out.printElement(this.getPresentationMLLabelTag(), this.getAttribute(LABEL), this.getLabelAttribute(id));
        return id;
    }

    default public boolean isLabel() {
        return this.getAttribute(LABEL) != null;
    }

    default public void validateLabel() throws InvalidInputException {
        String labelAttribute = this.getAttribute(LABEL);
        if (labelAttribute != null && labelAttribute.length() > 256) {
            throw new InvalidInputException(String.format(LABEL_TOO_LONG_ERR, 256));
        }
    }

    public String getAttribute(String var1);
}

