/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Bold;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.GroupedElement;
import org.symphonyoss.symphony.messageml.elements.Italic;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.CheckboxNode;

public class Checkbox
extends GroupedElement {
    public static final String MESSAGEML_TAG = "checkbox";
    public static final String PRESENTATIONML_INPUT_TYPE = "checkbox";
    public static final String PRESENTATIONML_DIV_CLASS = "checkbox-group";
    private static final String MARKDOWN = "Checkbox";

    public Checkbox(Element parent, FormatEnum messageFormat) {
        super(parent, "checkbox", messageFormat);
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute("checked") != null) {
            this.assertAttributeValue("checked", Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (!this.getChildren().isEmpty()) {
            this.assertContentModel(Arrays.asList(TextNode.class, Bold.class, Italic.class));
        }
        this.assertAttributeNotBlank("name");
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "value": 
            case "checked": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        if (this.hasExactNumberOfChildren(1)) {
            return new CheckboxNode(this.getChildren().get(0).asText());
        }
        return new CheckboxNode();
    }

    @Override
    protected String getPresentationMLInputType() {
        return "checkbox";
    }

    @Override
    protected String getPresentationMLDivClass() {
        return PRESENTATIONML_DIV_CLASS;
    }
}

