/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.w3c.dom.Node;

public class Span
extends Element {
    public static final String MESSAGEML_TAG = "span";
    private static final String ATTR_ENTITY_ID = "data-entity-id";

    public Span(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "data-entity-id": {
                this.setAttribute(ATTR_ENTITY_ID, this.getStringAttribute(item));
                break;
            }
            default: {
                super.buildAttribute(parser, item);
            }
        }
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        String entityId = this.getAttribute(ATTR_ENTITY_ID);
        if (entityId != null) {
            return (ObjectNode)parent.path(entityId);
        }
        return null;
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.getAttribute(ATTR_ENTITY_ID) != null && !"entity".equals(this.getAttribute("class"))) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is only allowed if the element class is \"entity\".");
        }
        if ("entity".equals(this.getAttribute("class")) && this.getAttribute(ATTR_ENTITY_ID) == null) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is required if the element class is \"entity\".");
        }
    }
}

