/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Bold;
import org.symphonyoss.symphony.messageml.elements.CashTag;
import org.symphonyoss.symphony.messageml.elements.Chime;
import org.symphonyoss.symphony.messageml.elements.Emoji;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.HashTag;
import org.symphonyoss.symphony.messageml.elements.Image;
import org.symphonyoss.symphony.messageml.elements.Italic;
import org.symphonyoss.symphony.messageml.elements.LineBreak;
import org.symphonyoss.symphony.messageml.elements.Link;
import org.symphonyoss.symphony.messageml.elements.Mention;
import org.symphonyoss.symphony.messageml.elements.RegexElement;
import org.symphonyoss.symphony.messageml.elements.Span;
import org.symphonyoss.symphony.messageml.elements.SplittableElement;
import org.symphonyoss.symphony.messageml.elements.Styles;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class Element {
    public static final String CLASS_ATTR = "class";
    public static final String STYLE_ATTR = "style";
    protected static final String ID_ATTR = "id";
    protected FormatEnum format;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<Element> children = new ArrayList<Element>();
    private final Element parent;
    private final String messageMLTag;

    Element(Element parent) {
        this(parent, null);
    }

    Element(Element parent, String messageMLTag) {
        this(parent, messageMLTag, FormatEnum.PRESENTATIONML);
    }

    Element(Element parent, String messageMLTag, FormatEnum format) {
        this.messageMLTag = messageMLTag;
        this.parent = parent;
        this.format = format;
    }

    public Boolean hasIdAttribute() {
        return false;
    }

    public void buildAll(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        NamedNodeMap attr = element.getAttributes();
        for (int i = 0; i < attr.getLength(); ++i) {
            this.buildAttribute(parser, attr.item(i));
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.buildNode(parser, children.item(i));
        }
    }

    void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "class": {
                this.attributes.put(CLASS_ATTR, this.getStringAttribute(item));
                break;
            }
            case "style": {
                String styleAttribute = this.getStringAttribute(item);
                Styles.validate(styleAttribute);
                this.attributes.put(STYLE_ATTR, styleAttribute);
                break;
            }
            default: {
                if (this instanceof RegexElement && RegexElement.ALL_REGEX_ATTRS.contains(item.getNodeName()) || this.format == FormatEnum.MESSAGEML && this instanceof SplittableElement && ((SplittableElement)((Object)this)).isSplittableNodeComponent(item)) {
                    this.attributes.put(item.getNodeName(), this.getStringAttribute(item));
                    break;
                }
                if (this.format == FormatEnum.PRESENTATIONML && this instanceof SplittableElement && ID_ATTR.equals(item.getNodeName())) {
                    ((SplittableElement)((Object)this)).fillAttributes(parser, item, this.attributes);
                    break;
                }
                this.throwInvalidInputException(item);
            }
        }
    }

    protected void buildNode(MessageMLParser context, org.w3c.dom.Node node) throws InvalidInputException, ProcessingException {
        switch (node.getNodeType()) {
            case 3: {
                this.buildText((Text)node);
                break;
            }
            case 1: {
                this.buildElement(context, (org.w3c.dom.Element)node);
                break;
            }
            default: {
                throw new InvalidInputException("Invalid element \"" + node.getNodeName() + "\"");
            }
        }
    }

    private void buildElement(MessageMLParser context, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        Element child = context.createElement(element, this);
        if (child != null) {
            child.buildAll(context, element);
            child.validate();
            if (child.hasIdAttribute().booleanValue()) {
                context.loadElementId(child.getAttribute(ID_ATTR));
            }
            this.addChild(child);
        } else if (element.getNodeName().equals("div")) {
            for (org.w3c.dom.Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.buildNode(context, node);
            }
        }
    }

    void buildText(Text text) {
        this.addChild(new TextNode(this, text));
    }

    void buildMarkdown(Node parent) throws InvalidInputException {
        for (Element child : this.children) {
            Node node = child.asMarkdown();
            if (node != null) {
                parent.appendChild(node);
            } else {
                node = parent;
            }
            child.buildMarkdown(node);
        }
    }

    void buildEntityJson(ObjectNode parent) {
        for (Element child : this.children) {
            ObjectNode node = child.asEntityJson(parent);
            if (node != null) {
                child.buildEntityJson(node);
                continue;
            }
            child.buildEntityJson(parent);
        }
    }

    Node asMarkdown() throws InvalidInputException {
        return null;
    }

    void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (this instanceof RegexElement) {
            RegexElement regexElement = (RegexElement)((Object)this);
            attributes.putAll(regexElement.getOtherAttributes());
            attributes.putAll(regexElement.getRegexAttrForPresentationML());
        } else {
            attributes.putAll(this.getAttributes());
        }
        if (this instanceof SplittableElement && ((SplittableElement)((Object)this)).isSplittable()) {
            ((SplittableElement)((Object)this)).splittableRemove().forEach(remove -> {
                String cfr_ignored_0 = (String)attributes.remove(remove);
            });
            String uid = ((SplittableElement)((Object)this)).splittableAsPresentationML(out, context);
            attributes.put(ID_ATTR, uid);
            this.innerAsPresentationML(out, context, attributes);
            out.closeElement();
        } else {
            this.innerAsPresentationML(out, context, attributes);
        }
    }

    private void innerAsPresentationML(XmlPrintStream out, MessageMLContext context, Map<String, String> attributes) {
        if (this.areNestedElementsAllowed()) {
            out.openElement(this.getPresentationMLTag(), attributes);
            for (Element child : this.getChildren()) {
                child.asPresentationML(out, context);
            }
            out.closeElement();
        } else {
            out.printElement(this.getPresentationMLTag(), attributes);
        }
    }

    public String asText() {
        StringBuilder b = new StringBuilder();
        for (Element child : this.children) {
            b.append(child.asText());
        }
        return b.toString();
    }

    ObjectNode asEntityJson(ObjectNode parent) {
        return null;
    }

    void validate() throws InvalidInputException {
        if (this instanceof RegexElement) {
            ((RegexElement)((Object)this)).validateRegex();
        }
        if (this instanceof SplittableElement) {
            ((SplittableElement)((Object)this)).validateSplittable();
        }
    }

    public String getStringAttribute(org.w3c.dom.Node attribute) {
        return attribute.getTextContent();
    }

    Long getLongAttribute(org.w3c.dom.Node attribute) throws InvalidInputException {
        String s = this.getStringAttribute(attribute);
        if (s == null) {
            return null;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException("Invalid input: " + attribute.getNodeName() + " must be a int64 value not \"" + s + "\"");
        }
    }

    Boolean getBooleanAttribute(org.w3c.dom.Node attribute) {
        String s = this.getStringAttribute(attribute);
        if (s == null) {
            return null;
        }
        return Boolean.parseBoolean(s);
    }

    URI getUrlAttribute(org.w3c.dom.Node attribute) throws InvalidInputException {
        String s = this.getStringAttribute(attribute);
        if (s == null) {
            return null;
        }
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            throw new InvalidInputException("Invalid input: " + attribute.getLocalName() + " must be a URI value not \"" + s + "\"");
        }
    }

    public boolean hasExactNumberOfChildren(int childrenNumber) {
        return this.getChildren() != null && this.getChildren().size() == childrenNumber;
    }

    void assertAttributeValue(String attributeName, Collection<String> permittedValues) throws InvalidInputException {
        String attributeValue = this.getAttribute(attributeName);
        if (!permittedValues.contains(attributeValue.toLowerCase())) {
            throw new InvalidInputException(String.format("Attribute \"%s\" of element \"%s\" can only be one of the following values: [%s].", attributeName, this.getMessageMLTag(), String.join((CharSequence)", ", permittedValues)));
        }
    }

    void assertAttributeNotBlank(String attributeName) throws InvalidInputException {
        String attributeValue = this.getAttribute(attributeName);
        if (attributeValue == null || attributeValue.trim().isEmpty()) {
            throw new InvalidInputException("The attribute \"" + attributeName + "\" is required");
        }
    }

    void assertNoContent() throws InvalidInputException {
        if (!this.getChildren().isEmpty()) {
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have child elements or text content");
        }
    }

    void assertNoAttributes() throws InvalidInputException {
        if (!this.getAttributes().isEmpty()) {
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have attributes");
        }
    }

    void assertNoText() throws InvalidInputException {
        for (Element child : this.getChildren()) {
            if (!(child instanceof TextNode) || !StringUtils.isNotBlank((CharSequence)((TextNode)child).getText())) continue;
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have text content");
        }
    }

    void assertPhrasingContent() throws InvalidInputException {
        this.assertContentModel(Arrays.asList(TextNode.class, Link.class, Chime.class, Bold.class, Italic.class, Image.class, LineBreak.class, Span.class, Emoji.class, HashTag.class, CashTag.class, Mention.class));
    }

    void assertContentModel(Collection<Class<? extends Element>> permittedChildren) throws InvalidInputException {
        for (Element child : this.getChildren()) {
            if (permittedChildren.contains(child.getClass()) || child instanceof TextNode && StringUtils.isBlank((CharSequence)((TextNode)child).getText())) continue;
            throw new InvalidInputException("Element \"" + child.getMessageMLTag() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
        }
    }

    void assertParent(Collection<Class<? extends Element>> permittedParents) throws InvalidInputException {
        if (!permittedParents.contains(this.getParent().getClass())) {
            String permittedParentsClassAsString = permittedParents.stream().map(permittedParentClass -> permittedParentClass.getSimpleName().toLowerCase()).reduce((item, anotherItem) -> String.format("%s, %s", item, anotherItem)).orElse("");
            throw new InvalidInputException(String.format("Element \"%s\" can only be a child of the following elements: [%s]", this.getMessageMLTag(), permittedParentsClassAsString));
        }
    }

    void assertParentAtAnyLevel(Collection<Class<? extends Element>> permittedParents) throws InvalidInputException {
        Boolean permittedParentFound = this.hasParentAtAnyLevel(permittedParents);
        if (!permittedParentFound.booleanValue()) {
            String permittedParentsClassAsString = permittedParents.stream().map(permittedParentClass -> permittedParentClass.getSimpleName().toLowerCase()).reduce((item, anotherItem) -> String.format("%s, %s", item, anotherItem)).orElse("");
            throw new InvalidInputException(String.format("Element \"%s\" can only be a inner child of the following elements: [%s]", this.getMessageMLTag(), permittedParentsClassAsString));
        }
    }

    void assertNotParentAtAnyLevel(Collection<Class<? extends Element>> forbiddenParents) throws InvalidInputException {
        Boolean forbiddenParentFound = this.hasParentAtAnyLevel(forbiddenParents);
        if (forbiddenParentFound.booleanValue()) {
            String forbiddenParentsClassAsString = forbiddenParents.stream().map(forbiddenParentClass -> forbiddenParentClass.getSimpleName().toLowerCase()).reduce((item, anotherItem) -> String.format("%s, %s", item, anotherItem)).orElse("");
            throw new InvalidInputException(String.format("Element \"%s\" cannot be an inner child of the following elements: [%s]", this.getMessageMLTag(), forbiddenParentsClassAsString));
        }
    }

    void assertContainsChildOfType(Collection<Class<? extends Element>> elementTypes) throws InvalidInputException {
        boolean hasPermittedElementAsChild = this.getChildren().stream().anyMatch(element -> elementTypes.contains(element.getClass()));
        if (!hasPermittedElementAsChild) {
            throw new InvalidInputException(String.format("The \"%s\" element must have at least one child that is any of the following elements: [%s].", this.getMessageMLTag(), this.getElementsNameByClassName(elementTypes)));
        }
    }

    void assertChildrenNotExceedingMaxCount(Collection<Class<? extends Element>> elementTypes, int maxCountPerElementType) throws InvalidInputException {
        boolean hasExceeded = elementTypes.stream().anyMatch(type -> this.findElements((Class<?>)type).size() > maxCountPerElementType);
        if (hasExceeded) {
            throw new InvalidInputException(String.format("Element \"%s\" cannot have more than %s children of the following elements: [%s].", this.getElementNameByClass(this.getClass()), maxCountPerElementType, this.getElementsNameByClassName(elementTypes)));
        }
    }

    public final String getMessageMLTag() {
        return this.messageMLTag;
    }

    public String getPresentationMLTag() {
        return this.messageMLTag;
    }

    public boolean areNestedElementsAllowed() {
        return true;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attr) {
        return this.attributes.get(attr);
    }

    void setAttribute(String attr, String value) {
        this.attributes.put(attr, value);
    }

    public List<Element> getChildren() {
        return this.children;
    }

    public Element getChild(int n) {
        return this.children.get(n);
    }

    public void addChild(Element child) {
        this.children.add(child);
    }

    public int size() {
        return this.children.size();
    }

    public Element getParent() {
        return this.parent;
    }

    public FormatEnum getFormat() {
        return this.format;
    }

    public List<Element> findElements(Class<?> type) {
        ArrayList<Element> result = new ArrayList<Element>();
        LinkedList<Element> stack = new LinkedList<Element>(this.getChildren());
        if (this.getClass() == type) {
            result.add(this);
        }
        while (!stack.isEmpty()) {
            Element child = stack.pop();
            stack.addAll(0, child.getChildren());
            if (child.getClass() != type) continue;
            result.add(child);
        }
        return result;
    }

    public List<Element> findElements(String tag) {
        ArrayList<Element> result = new ArrayList<Element>();
        LinkedList<Element> stack = new LinkedList<Element>(this.getChildren());
        if (tag.equalsIgnoreCase(this.getMessageMLTag())) {
            result.add(this);
        }
        while (!stack.isEmpty()) {
            Element child = stack.pop();
            stack.addAll(0, child.getChildren());
            if (!tag.equalsIgnoreCase(child.getMessageMLTag())) continue;
            result.add(child);
        }
        return result;
    }

    public List<Element> findElements(String attribute, String value) {
        ArrayList<Element> result = new ArrayList<Element>();
        LinkedList<Element> stack = new LinkedList<Element>(this.getChildren());
        if (value.equals(this.getAttribute(attribute))) {
            result.add(this);
        }
        while (!stack.isEmpty()) {
            Element child = stack.pop();
            stack.addAll(0, child.getChildren());
            if (!value.equals(child.getAttribute(attribute))) continue;
            result.add(child);
        }
        return result;
    }

    public Integer countNonTextNodesInNodeList(NodeList nodeList) {
        Integer numberOfNonTextNodes = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if ("#text".equals(nodeList.item(i).getNodeName())) continue;
            Integer n = numberOfNonTextNodes;
            Integer n2 = numberOfNonTextNodes = Integer.valueOf(numberOfNonTextNodes + 1);
        }
        return numberOfNonTextNodes;
    }

    private String getElementsNameByClassName(Collection<Class<? extends Element>> elementsClasses) {
        return elementsClasses.stream().map(this::getElementNameByClass).collect(Collectors.joining(", "));
    }

    private String getElementNameByClass(Class<? extends Element> element) {
        return element.equals(TextNode.class) ? "text content" : element.getSimpleName().toLowerCase();
    }

    private Boolean hasParentAtAnyLevel(Collection<Class<? extends Element>> possibleParents) {
        Element element = this;
        Boolean parentFound = false;
        while (!parentFound.booleanValue() && element.getParent() != null) {
            if (possibleParents.contains(element.getParent().getClass())) {
                parentFound = true;
                continue;
            }
            element = element.getParent();
        }
        return parentFound;
    }

    protected void throwInvalidInputException(org.w3c.dom.Node item) throws InvalidInputException {
        throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
    }
}

