/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.Option;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.SelectNode;

public class Select
extends FormElement
implements LabelableElement,
TooltipableElement {
    public static final String MESSAGEML_TAG = "select";
    public static final String ELEMENT_ID = "dropdown";
    private static final String REQUIRED_ATTR = "required";
    private static final String OPTION_SELECTED_ATTR = "selected";
    private static final String DATA_PLACEHOLDER_ATTR = "data-placeholder";

    public Select(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    public Node asMarkdown() {
        return new SelectNode(this.getAttribute(DATA_PLACEHOLDER_ATTR));
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        this.assertContentModel(Collections.singleton(Option.class));
        this.assertContainsChildOfType(Collections.singleton(Option.class));
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        this.assertOnlyOneOptionSelected();
        this.assertAttributeNotBlank("name");
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "required": 
            case "data-placeholder": 
            case "label": 
            case "title": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "id": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public String getElementId() {
        return ELEMENT_ID;
    }

    private void assertOnlyOneOptionSelected() throws InvalidInputException {
        long numberOfSelectedOptions = this.getChildren().stream().map(child -> child.getAttribute(OPTION_SELECTED_ATTR)).filter(selectedAttr -> selectedAttr != null && selectedAttr.equalsIgnoreCase(Boolean.TRUE.toString())).count();
        if (numberOfSelectedOptions > 1L) {
            throw new InvalidInputException("Element \"select\" can only have one selected \"option\"");
        }
    }
}

