/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.DateSelectorNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DateSelector
extends FormElement {
    public static final String MESSAGEML_TAG = "date-selector";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String REQUIRED_ATTR = "required";
    private static final Set<String> VALID_VALUES_FOR_REQUIRED_ATTR = new HashSet<String>(Arrays.asList("true", "false"));
    private static final String PRESENTATIONML_NAME_ATTR = "data-name";
    private static final String PRESENTATIONML_PLACEHOLDER_ATTR = "data-placeholder";
    private static final String PRESENTATIONML_REQUIRED_ATTR = "data-required";
    private static final String PRESENTATIONML_TAG = "div";
    private static final String MARKDOWN = "Date Selector";
    private static final String CLASS_ATTR = "class";

    public DateSelector(Element parent, FormatEnum messageFormat) {
        super(parent, MESSAGEML_TAG, messageFormat);
    }

    @Override
    public void buildAll(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(parser, element);
                break;
            }
            case PRESENTATIONML: {
                this.buildElementFromDiv(parser, element);
                this.validate();
                break;
            }
            default: {
                throw new InvalidInputException(String.format("Invalid message format for \"%s\" element", MESSAGEML_TAG));
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_VALUES_FOR_REQUIRED_ATTR);
        }
        this.assertNoContent();
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        Map<String, String> presentationAttrs = this.buildDateSelectorInputAttributes();
        out.openElement(PRESENTATIONML_TAG, presentationAttrs);
        out.closeElement();
    }

    @Override
    public Node asMarkdown() {
        return new DateSelectorNode(this.getAttribute(PLACEHOLDER_ATTR));
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "placeholder": {
                this.setAttribute(PLACEHOLDER_ATTR, this.getStringAttribute(item));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public String getPresentationMLTag() {
        return PRESENTATIONML_TAG;
    }

    private Map<String, String> buildDateSelectorInputAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put(CLASS_ATTR, MESSAGEML_TAG);
        presentationAttrs.put(PRESENTATIONML_NAME_ATTR, this.getAttribute("name"));
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_PLACEHOLDER_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_REQUIRED_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        return presentationAttrs;
    }

    void buildElementFromDiv(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        element.setAttribute("name", element.getAttribute(PRESENTATIONML_NAME_ATTR));
        element.removeAttribute(PRESENTATIONML_NAME_ATTR);
        if (element.hasAttribute(PRESENTATIONML_PLACEHOLDER_ATTR)) {
            element.setAttribute(PLACEHOLDER_ATTR, element.getAttribute(PRESENTATIONML_PLACEHOLDER_ATTR));
            element.removeAttribute(PRESENTATIONML_PLACEHOLDER_ATTR);
        }
        if (element.hasAttribute(PRESENTATIONML_REQUIRED_ATTR)) {
            element.setAttribute(REQUIRED_ATTR, element.getAttribute(PRESENTATIONML_REQUIRED_ATTR));
            element.removeAttribute(PRESENTATIONML_REQUIRED_ATTR);
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.buildAttribute(parser, attributes.item(i));
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.buildNode(parser, children.item(i));
        }
    }
}

