/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.util;

import java.security.SecureRandom;
import java.util.Random;

public class ShortID {
    public static final String DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-";
    private static final long DEFAULT_REDUCE_TIME = 1403265799803L;
    private static final int DEFAULT_VERSION = 6;
    private final Random random;
    private final long reduceTime;
    private final int version;
    private final int clusterWorkerId;
    private final char[] shuffled;
    private volatile int counter;
    private volatile long previousSeconds;

    public ShortID(Random random, String alphabet, long reduceTime, int version, int clusterWorkerId) {
        this.random = random;
        this.shuffled = this.shuffle(alphabet);
        this.reduceTime = reduceTime;
        this.version = version;
        this.clusterWorkerId = clusterWorkerId;
    }

    public ShortID() {
        this(new SecureRandom(), DEFAULT_ALPHABET, 1403265799803L, 6, 0);
    }

    public String generate() {
        String str = "";
        long seconds = (long)Math.floor((double)(System.currentTimeMillis() - this.reduceTime) * 0.001);
        if (seconds == this.previousSeconds) {
            ++this.counter;
        } else {
            this.counter = 0;
            this.previousSeconds = seconds;
        }
        str = str + this.encode(this.version);
        str = str + this.encode(this.clusterWorkerId);
        if (this.counter > 0) {
            str = str + this.encode(this.counter);
        }
        str = str + this.encode((int)seconds);
        return str;
    }

    private String encode(int number) {
        int loopCounter = 0;
        boolean done = false;
        String str = "";
        while (!done) {
            int index = number >> 4 * loopCounter & 0xF | this.randomByte();
            str = str + this.shuffled[index];
            done = (double)number < Math.pow(16.0, loopCounter + 1);
            ++loopCounter;
        }
        return str;
    }

    private int randomByte() {
        byte[] bytes = new byte[1];
        this.random.nextBytes(bytes);
        return bytes[0] & 0x30;
    }

    private char[] shuffle(String alphabet) {
        StringBuilder source = new StringBuilder(alphabet);
        StringBuilder target = new StringBuilder(source.length());
        while (source.length() > 0) {
            double r = this.random.nextDouble();
            int charIndex = (int)Math.floor(r * (double)source.length());
            target.append(source.charAt(charIndex));
            source.deleteCharAt(charIndex);
        }
        return target.toString().toCharArray();
    }
}

