/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.bi;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.symphony.messageml.bi.BiContext;

public class BiItem {
    private static final Logger logger = LoggerFactory.getLogger(BiContext.class);
    private final String name;
    private final Map<String, Object> attributes;

    public BiItem(String name, Map<String, Object> attributes) {
        this.name = name;
        this.attributes = attributes;
    }

    public BiItem(String name, String attribute) {
        this.name = name;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(attribute, 1);
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected void increaseAttributeCount(String attributeName) {
        try {
            Integer value = (Integer)this.attributes.getOrDefault(attributeName, 0) + 1;
            this.attributes.put(attributeName, value);
        }
        catch (ClassCastException e) {
            logger.warn("Attribute {} for element {} does not contain an integer value. The count will not be increased.", (Object)attributeName, (Object)this.getName());
        }
    }
}

