/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Form;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.elements.UIAction;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.ButtonNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class Button
extends Element {
    Logger logger = LoggerFactory.getLogger(Button.class);
    public static final String MESSAGEML_TAG = "button";
    public static final String ACTION_TYPE = "action";
    public static final String RESET_TYPE = "reset";
    private static final Set<String> VALID_CLASSES = new HashSet<String>(Arrays.asList("primary", "secondary", "tertiary", "destructive", "primary-destructive", "secondary-destructive"));
    private static final Set<String> VALID_TYPES = new HashSet<String>(Arrays.asList("action", "reset"));

    public Button(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
        if (!this.isUIActionButton()) {
            this.setAttribute("type", ACTION_TYPE);
        }
    }

    @Override
    public void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "type": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "class": {
                if (this.getStringAttribute(item).contains("-destructive")) {
                    this.logger.info("Button class cannot be a destructive one, replacing it accordingly.");
                }
                this.setAttribute(item.getNodeName(), StringUtils.removeEnd((String)this.getStringAttribute(item), (String)"-destructive"));
                break;
            }
            case "title": {
                if (this.format != FormatEnum.MESSAGEML) {
                    this.throwInvalidInputException(item);
                }
                this.setAttribute("title", this.getStringAttribute(item));
                break;
            }
            case "data-title": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.setAttribute("data-title", this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.openElement(this.getPresentationMLTag(), this.getPresentationMLAttributes());
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    private Map<String, String> getPresentationMLAttributes() {
        Map<String, String> attributes = this.getAttributes();
        if (this.format == FormatEnum.MESSAGEML && attributes.containsKey("title")) {
            LinkedHashMap<String, String> presentationAttributes = new LinkedHashMap<String, String>(attributes);
            presentationAttributes.put("data-title", attributes.get("title"));
            presentationAttributes.remove("title");
            return presentationAttributes;
        }
        return attributes;
    }

    @Override
    public Node asMarkdown() {
        return new ButtonNode();
    }

    @Override
    public void validate() throws InvalidInputException {
        this.assertParentAtAnyLevel(Arrays.asList(Form.class, UIAction.class));
        this.validateCommonAttributes();
        if (this.isUIActionButton()) {
            this.validateUIActionButton();
        } else {
            this.validateFormButton();
        }
    }

    private void validateCommonAttributes() throws InvalidInputException {
        String clazz = this.getAttribute("class");
        if (clazz != null && !VALID_CLASSES.contains(clazz)) {
            throw new InvalidInputException("Attribute \"class\" must be \"primary\", \"secondary\", \"tertiary\" or \"destructive\" (\"primary-destructive\" and \"secondary-destructive\" are deprecated)");
        }
    }

    private void validateUIActionButton() throws InvalidInputException {
        if (this.getAttribute("type") != null || this.getAttribute("name") != null) {
            throw new InvalidInputException("Attributes \"type\" and \"name\" are not allowed on a button inside a UIAction.");
        }
    }

    private void validateFormButton() throws InvalidInputException {
        String type = this.getAttribute("type");
        String name = this.getAttribute("name");
        if (!VALID_TYPES.contains(type)) {
            throw new InvalidInputException("Attribute \"type\" must be \"action\" or \"reset\"");
        }
        if (type.equals(ACTION_TYPE) && StringUtils.isBlank((CharSequence)name)) {
            throw new InvalidInputException("Attribute \"name\" is required for action buttons");
        }
        if (type.equals(RESET_TYPE) && this.getAttributes().containsKey("name")) {
            throw new InvalidInputException("Attribute \"name\" is allowed for action buttons only");
        }
        this.assertContentModel(Collections.singleton(TextNode.class));
        this.assertContainsChildOfType(Collections.singleton(TextNode.class));
    }

    private boolean isUIActionButton() {
        return this.getParent().getClass().equals(UIAction.class);
    }

    @Override
    public void updateBiContext(BiContext context) {
        HashMap<String, Object> attributesMapBi = new HashMap<String, Object>();
        attributesMapBi.put("type", this.getAttributes().getOrDefault("type", ""));
        attributesMapBi.put("class", this.getAttributes().getOrDefault("class", ""));
        attributesMapBi.put("title", this.getAttributes().containsKey("title") ? Integer.valueOf(1) : "");
        context.addItem(new BiItem("Button", attributesMapBi));
    }
}

