/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.DatePickerNode;
import org.symphonyoss.symphony.messageml.util.XMLAttribute;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.symphonyoss.symphony.messageml.util.pojo.DateInterval;

public class DatePicker
extends FormElement
implements LabelableElement,
TooltipableElement {
    public static final String MESSAGEML_TAG = "date-picker";
    public static final String PRESENTATIONML_INPUT_TYPE = "date";
    private static final String PRESENTATIONML_TAG = "input";
    private static final String VALUE_ATTR = "value";
    private static final String REQUIRED_ATTR = "required";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String MIN_ATTR = "min";
    private static final String MAX_ATTR = "max";
    private static final String DISABLED_DATE_ATTR = "disabled-date";
    private static final String HIGHLIGHTED_DATE_ATTR = "highlighted-date";
    private static final String FORMAT_ATTR = "format";
    private static final int DATE_RANGE_MAX_LENGTH = 1024;
    private static final int DEFAULT_MAX_LENGTH = 64;
    private static final String DISABLED_DATE_PRESENTATION_ATTR = "data-disabled-date";
    private static final String HIGHLIGHTED_DATE_PRESENTATION_ATTR = "data-highlighted-date";
    private static final String FORMAT_PRESENTATION_ATTR = "data-format";
    private static final String DATE_FORMAT_ALLOWED = "^[0-9Mdy\\/. -:]+$";

    public DatePicker(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "value": 
            case "required": 
            case "placeholder": 
            case "min": 
            case "max": 
            case "label": 
            case "title": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "disabled-date": 
            case "highlighted-date": 
            case "format": {
                if (this.format != FormatEnum.MESSAGEML) {
                    this.throwInvalidInputException(item);
                }
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "id": 
            case "data-disabled-date": 
            case "data-highlighted-date": 
            case "data-format": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        this.assertAttributeNotBlank("name");
        this.assertAttributeMaxLength("name", 64);
        if (this.getAttribute(VALUE_ATTR) != null) {
            this.assertDateFormat(VALUE_ATTR, DateTimeFormatter.ISO_DATE);
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, Arrays.asList("true", "false"));
        }
        if (this.getAttribute(MIN_ATTR) != null) {
            this.assertDateFormat(MIN_ATTR, DateTimeFormatter.ISO_DATE);
        }
        if (this.getAttribute(MAX_ATTR) != null) {
            this.assertDateFormat(MAX_ATTR, DateTimeFormatter.ISO_DATE);
        }
        this.assertJsonDatesRange(DISABLED_DATE_ATTR);
        this.assertJsonDatesRange(HIGHLIGHTED_DATE_ATTR);
        if (this.getAttribute(FORMAT_ATTR) != null) {
            this.assertAttributeMaxLength(FORMAT_ATTR, 64);
            String format = this.getAttribute(FORMAT_ATTR);
            if (!format.matches(DATE_FORMAT_ALLOWED)) {
                throw new InvalidInputException(String.format("Attribute \"%s\" contains an unsupported date format, only 'M', 'd' and 'y' are supported with a space or '.','-','/',':' as separator", FORMAT_ATTR));
            }
            try {
                DateTimeFormatter.ofPattern(this.getAttribute(FORMAT_ATTR));
            }
            catch (IllegalArgumentException i) {
                throw new InvalidInputException(String.format("Attribute \"%s\" contains an invalid date format", FORMAT_ATTR));
            }
        }
        this.assertAttributeMaxLength("title", 64);
        this.assertAttributeMaxLength("label", 64);
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        Map<String, Object> presentationAttrs = this.buildDataPickerInputAttributes();
        if (this.isSplittable()) {
            presentationAttrs.put("id", this.splittableAsPresentationML(out, context));
            this.innerAsPresentationML(out, presentationAttrs);
            out.closeElement();
        } else {
            this.innerAsPresentationML(out, presentationAttrs);
        }
    }

    @Override
    public Node asMarkdown() {
        return new DatePickerNode(this.getAttribute("label"), this.getAttribute("title"), this.getAttribute(PLACEHOLDER_ATTR));
    }

    private void innerAsPresentationML(XmlPrintStream out, Map<String, Object> presentationAttrs) {
        out.openElement(PRESENTATIONML_TAG, presentationAttrs);
        out.closeElement();
    }

    private Map<String, Object> buildDataPickerInputAttributes() {
        LinkedHashMap<String, Object> presentationAttrs = new LinkedHashMap<String, Object>();
        presentationAttrs.put("type", PRESENTATIONML_INPUT_TYPE);
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(VALUE_ATTR) != null) {
            presentationAttrs.put(VALUE_ATTR, this.getAttribute(VALUE_ATTR));
        }
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PLACEHOLDER_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(MIN_ATTR) != null) {
            presentationAttrs.put(MIN_ATTR, this.getAttribute(MIN_ATTR));
        }
        if (this.getAttribute(MAX_ATTR) != null) {
            presentationAttrs.put(MAX_ATTR, this.getAttribute(MAX_ATTR));
        }
        if (this.getAttribute(DISABLED_DATE_ATTR) != null) {
            presentationAttrs.put(DISABLED_DATE_PRESENTATION_ATTR, this.convertJsonDateToPresentationML(DISABLED_DATE_ATTR));
        }
        if (this.getAttribute(HIGHLIGHTED_DATE_ATTR) != null) {
            presentationAttrs.put(HIGHLIGHTED_DATE_PRESENTATION_ATTR, this.convertJsonDateToPresentationML(HIGHLIGHTED_DATE_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(REQUIRED_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        if (this.getAttribute(FORMAT_ATTR) != null) {
            presentationAttrs.put(FORMAT_PRESENTATION_ATTR, this.getAttribute(FORMAT_ATTR));
        }
        return presentationAttrs;
    }

    private XMLAttribute convertJsonDateToPresentationML(String attributeName) {
        try {
            DateInterval[] dateIntervals = (DateInterval[])MAPPER.readValue(this.getAttribute(attributeName), DateInterval[].class);
            String result = MAPPER.writeValueAsString((Object)dateIntervals);
            return XMLAttribute.of(result, XMLAttribute.Format.JSON);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void assertJsonDatesRange(String attributeName) throws InvalidInputException {
        String attributeValue = this.getAttribute(attributeName);
        if (attributeValue != null) {
            if (attributeValue.length() > 1024) {
                throw new InvalidInputException(String.format("Attribute \"%s\" exceed maximum allowed length (%d)", attributeName, 1024));
            }
            try {
                DateInterval[] dateIntervals;
                for (DateInterval dateInterval : dateIntervals = (DateInterval[])MAPPER.readValue(attributeValue, DateInterval[].class)) {
                    dateInterval.assertIsValid();
                }
            }
            catch (JsonProcessingException e) {
                throw new InvalidInputException(String.format("Error parsing json in attribute \"%s\": %s", attributeName, e.getMessage()), e);
            }
        }
    }
}

