/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.MessageML;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.MarkdownParser;
import org.symphonyoss.symphony.messageml.markdown.MarkdownRenderer;
import org.symphonyoss.symphony.messageml.util.IDataProvider;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class MessageMLContext {
    private final MessageMLParser messageMLParser;
    private final MarkdownParser markdownParser;
    private MarkdownRenderer markdownRenderer;
    private MessageML messageML;
    private ObjectNode entityJson;

    public MessageMLContext(IDataProvider dataProvider) {
        this.markdownParser = new MarkdownParser(dataProvider);
        this.messageMLParser = new MessageMLParser(dataProvider);
    }

    public void parseMessageML(String message, String entityJson, String version) throws InvalidInputException, IOException, ProcessingException {
        this.messageML = this.messageMLParser.parse(message, entityJson, version);
        this.entityJson = this.messageMLParser.getEntityJson();
        this.markdownRenderer = new MarkdownRenderer(this.messageML.asMarkdown());
    }

    public void parseMarkdown(String message, JsonNode entities, JsonNode media) throws InvalidInputException {
        this.messageML = this.markdownParser.parse(message, entities, media);
        this.entityJson = this.messageML.asEntityJson(this.entityJson);
        this.markdownRenderer = new MarkdownRenderer(this.messageML.asMarkdown());
    }

    public MessageML getMessageML() throws IllegalStateException {
        if (this.messageML == null) {
            throw new IllegalStateException("The message hasn't been parsed yet. Please call MessageMLContext.parse() first.");
        }
        return this.messageML;
    }

    public String getPresentationML() throws IllegalStateException {
        if (this.messageML == null) {
            throw new IllegalStateException("The message hasn't been parsed yet. Please call MessageMLContext.parse() first.");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XmlPrintStream out = new XmlPrintStream(bout);
        out.setNoIndent(true);
        out.setNoNl(true);
        this.messageML.asPresentationML(out);
        out.close();
        return bout.toString();
    }

    public ObjectNode getEntityJson() {
        if (this.messageML == null) {
            throw new IllegalStateException("The message hasn't been parsed yet. Please call MessageMLContext.parse() first.");
        }
        return this.entityJson;
    }

    public String getMarkdown() throws IllegalStateException {
        if (this.messageML == null) {
            throw new IllegalStateException("The message hasn't been parsed yet. Please call MessageMLContext.parse() first.");
        }
        return this.markdownRenderer.getText();
    }

    public JsonNode getEntities() throws IllegalStateException {
        if (this.messageML == null) {
            throw new IllegalStateException("The message hasn't been parsed yet. Please call MessageMLContext.parse() first.");
        }
        return this.markdownRenderer.getJson();
    }
}

