/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.Select;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.OptionNode;

public class Option
extends FormElement {
    public static final String MESSAGEML_TAG = "option";
    private static final String VALUE_ATTR = "value";
    private static final String SELECTED_ATTR = "selected";

    public Option(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    public Node asMarkdown() {
        return new OptionNode();
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.getAttribute(VALUE_ATTR) == null) {
            throw new InvalidInputException("The attribute \"value\" is required");
        }
        if (this.getAttribute(SELECTED_ATTR) != null) {
            this.assertAttributeValue(SELECTED_ATTR, Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        this.assertParent(Collections.singleton(Select.class));
        this.assertContentModel(Collections.singleton(TextNode.class));
        this.assertContainsChildOfType(Collections.singleton(TextNode.class));
    }

    @Override
    public void updateBiContext(BiContext context) {
        HashMap<String, Object> attributesMapBi = new HashMap<String, Object>();
        attributesMapBi.put(BiFields.OPTIONS_COUNT.getValue(), 1);
        this.putOneIfPresent(attributesMapBi, BiFields.DEFAULT.getValue(), SELECTED_ATTR);
        context.updateItemCount(BiFields.OPTION.getValue(), attributesMapBi);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "value": {
                this.setAttribute(VALUE_ATTR, this.getStringAttribute(item));
                break;
            }
            case "selected": {
                this.setAttribute(SELECTED_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }
}

