/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Collections;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.elements.Dialog;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public abstract class DialogChild
extends Element {
    public static final String DIALOG_CLASS_PREFIX = "dialog-";

    public DialogChild(Element parent, String messageMLTag, FormatEnum format) {
        super(parent, messageMLTag, format);
    }

    @Override
    public void validate() throws InvalidInputException {
        this.assertNoAttributes();
        this.assertParent(Collections.singleton(Dialog.class));
        boolean containsDialog = this.getChildren().stream().anyMatch(e -> e instanceof Dialog);
        if (containsDialog) {
            throw new InvalidInputException(this.getMessageMLTag() + " should not contain a dialog");
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.openElement("div", Collections.singletonMap("class", DIALOG_CLASS_PREFIX + this.getMessageMLTag()));
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    public static class Footer
    extends DialogChild {
        public static final String MESSAGEML_TAG = "footer";

        public Footer(Element parent, FormatEnum format) {
            super(parent, MESSAGEML_TAG, format);
        }
    }

    public static class Body
    extends DialogChild {
        public static final String MESSAGEML_TAG = "body";

        public Body(Element parent, FormatEnum format) {
            super(parent, MESSAGEML_TAG, format);
        }
    }

    public static class Title
    extends DialogChild {
        public static final String MESSAGEML_TAG = "title";

        public Title(Element parent, FormatEnum format) {
            super(parent, MESSAGEML_TAG, format);
        }
    }
}

