/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.DialogChild;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.DialogNode;
import org.symphonyoss.symphony.messageml.util.ShortID;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class Dialog
extends Element {
    public static final String MESSAGEML_TAG = "dialog";
    public static final int ID_MAX_LENGTH = 64;
    public static final String STATE_ATTR = "state";
    public static final String CLOSE_STATE = "close";
    public static final List<String> ALLOWED_STATE_VALUES = Arrays.asList("open", "close");
    public static final String WIDTH_ATTR = "width";
    public static final String MEDIUM_WIDTH = "medium";
    public static final List<String> ALLOWED_WIDTH_VALUES = Arrays.asList("small", "medium", "large", "full-width");
    private static final String DATA_ATTRIBUTE_PREFIX = "data-";
    private static final String OPEN_ATTRIBUTE = "open";
    private static final ShortID SHORT_ID = new ShortID();

    public Dialog(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
    }

    @Override
    public Boolean hasIdAttribute() {
        return true;
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "id": 
            case "width": 
            case "state": {
                this.setAttribute(item.getNodeName(), item.getNodeValue());
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        this.checkAttributes();
        this.validateChildrenTypes();
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.openElement(this.getPresentationMLTag(), this.getPresentationMLAttributes());
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    @Override
    Node asMarkdown() throws InvalidInputException {
        return new DialogNode();
    }

    @Override
    void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        context.updateItemCount(BiFields.POPUPS.getValue());
    }

    private void checkAttributes() throws InvalidInputException {
        this.validateIdAttribute();
        this.checkAttributeOrPutDefaultValue(WIDTH_ATTR, MEDIUM_WIDTH, ALLOWED_WIDTH_VALUES);
        this.checkAttributeOrPutDefaultValue(STATE_ATTR, CLOSE_STATE, ALLOWED_STATE_VALUES);
    }

    private void validateIdAttribute() throws InvalidInputException {
        String id = this.getAttribute("id");
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.containsWhitespace((CharSequence)id)) {
            throw new InvalidInputException("The attribute \"id\" is required and must not contain any whitespace");
        }
        this.assertAttributeMaxLength("id", 64);
    }

    private void checkAttributeOrPutDefaultValue(String attributeName, String defaultValue, List<String> allowedValues) throws InvalidInputException {
        if (this.getAttribute(attributeName) == null) {
            this.setAttribute(attributeName, defaultValue);
        }
        this.assertAttributeValue(attributeName, allowedValues);
    }

    private void validateChildrenTypes() throws InvalidInputException {
        this.assertContainsAlwaysChildOfType(Collections.singleton(DialogChild.Title.class));
        this.assertContainsAlwaysChildOfType(Collections.singleton(DialogChild.Body.class));
        this.validateNoOtherChildrenTypes();
    }

    private void validateNoOtherChildrenTypes() throws InvalidInputException {
        boolean areAllChildrenOfAllowedTypes = this.getChildren().stream().allMatch(element -> element instanceof DialogChild);
        if (!areAllChildrenOfAllowedTypes) {
            throw new InvalidInputException("A dialog can only contain tags \"title\", \"body\", \"footer\"");
        }
    }

    private Map<String, String> getPresentationMLAttributes() {
        HashMap<String, String> pmlAttributes = new HashMap<String, String>();
        pmlAttributes.put(OPEN_ATTRIBUTE, "");
        for (Map.Entry<String, String> mmlAttribute : this.getAttributes().entrySet()) {
            if (mmlAttribute.getKey().equals("id")) {
                pmlAttributes.put(mmlAttribute.getKey(), SHORT_ID.generate() + "-" + mmlAttribute.getValue());
                continue;
            }
            pmlAttributes.put(DATA_ATTRIBUTE_PREFIX + mmlAttribute.getKey(), mmlAttribute.getValue());
        }
        return pmlAttributes;
    }
}

