/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.util;

import java.io.OutputStream;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import org.symphonyoss.symphony.messageml.util.IndentedPrintStream;
import org.symphonyoss.symphony.messageml.util.XMLAttribute;

public class XmlPrintStream
extends IndentedPrintStream {
    private final Deque<String> elementStack = new LinkedList<String>();

    public XmlPrintStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void startElement(String name, Object ... attributes) {
        this.println("<" + name);
        this.indent();
        int i = 0;
        while (i < attributes.length) {
            if (i < attributes.length - 1) {
                this.printAttribute(attributes[i++].toString(), attributes[i++]);
                continue;
            }
            this.printAttribute(attributes[i++].toString(), null);
        }
    }

    public void openElement(String name) {
        this.elementStack.push(name);
        this.println("<" + name + ">");
        this.indent();
    }

    public void openElement(String name, Map<?, ?> attributes) {
        this.elementStack.push(name);
        this.print("<" + name);
        for (Map.Entry<?, ?> entry : attributes.entrySet()) {
            this.printAttribute(entry.getKey(), entry.getValue());
        }
        if (this.isNoNl()) {
            this.print(">");
        } else {
            this.println(">");
        }
        this.indent();
    }

    public void openElement(String name, Object ... attributes) {
        this.elementStack.push(name);
        this.startElement(name, attributes);
        this.println(">");
    }

    public void closeElement() {
        this.outdent();
        if (this.isNoNl()) {
            this.print("</" + this.elementStack.pop() + ">");
        } else {
            this.println("</" + this.elementStack.pop() + ">");
        }
    }

    public void printElement(String elementName, Object value) {
        this.println("<" + elementName + ">" + (value == null ? "" : this.escape(value.toString())) + "</" + elementName + ">");
    }

    public void printElement(String name, String value, Object ... attributes) {
        this.startElement(name, attributes);
        if (value != null) {
            this.println(">" + this.escape(value) + "</" + name + ">");
        } else {
            this.println("/>");
        }
        this.outdent();
    }

    public void printElement(String elementName, Map<?, ?> attributes) {
        this.printElement(elementName, null, attributes);
    }

    public void printElement(String elementName, String value, Map<?, ?> attributes) {
        this.print("<" + elementName);
        for (Map.Entry<?, ?> entry : attributes.entrySet()) {
            this.printAttribute(entry.getKey(), entry.getValue());
        }
        if (value != null) {
            this.println(">" + this.escape(value) + "</" + elementName + ">");
        } else {
            this.println("/>");
        }
    }

    public void printElement(String name) {
        this.println("<" + name + "/>");
    }

    public void printComment(String comment) {
        this.println("<!-- " + comment + " -->");
    }

    public String escape(String in) {
        return this.escape(in, XMLAttribute.Format.STANDARD);
    }

    public String escape(String in, XMLAttribute.Format format) {
        StringBuilder out = new StringBuilder();
        block7: for (char c : in.toCharArray()) {
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    if (XMLAttribute.Format.JSON.equals((Object)format)) {
                        out.append(c);
                        continue block7;
                    }
                    out.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    if (XMLAttribute.Format.JSON.equals((Object)format)) {
                        out.append("&apos;");
                        continue block7;
                    }
                    out.append(c);
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public static String removeNewLines(String textContent) {
        if (textContent == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        boolean inNl = false;
        for (char c : textContent.toCharArray()) {
            if (c == '\n') {
                if (inNl) continue;
                s.append(' ');
                inNl = true;
                continue;
            }
            inNl = false;
            s.append(c);
        }
        return s.toString();
    }

    private void printAttribute(Object attrName, Object attrValue) {
        if (attrValue == null) {
            this.println(" " + attrName);
        } else {
            XMLAttribute.Format format = attrValue instanceof XMLAttribute ? ((XMLAttribute)attrValue).getFormat() : XMLAttribute.Format.STANDARD;
            if (XMLAttribute.Format.JSON.equals((Object)format)) {
                this.append(' ');
                this.append(attrName.toString());
                this.append("='");
                this.append(this.escape(attrValue.toString(), format));
                this.append('\'');
            } else {
                this.append(' ');
                this.append(attrName.toString());
                this.append("=\"");
                this.append(this.escape(attrValue.toString(), format));
                this.append('\"');
            }
        }
    }
}

