/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.util.IDataProvider;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class Link
extends Element {
    public static final String MESSAGEML_TAG = "a";
    private static final String ATTR_HREF = "href";
    private final IDataProvider dataProvider;
    private URI uri;

    public Link(Element parent, IDataProvider dataProvider) throws InvalidInputException {
        this(parent, null, dataProvider);
    }

    public Link(Element parent, String href, IDataProvider dataProvider) throws InvalidInputException {
        super(parent, MESSAGEML_TAG);
        this.dataProvider = dataProvider;
        if (href != null) {
            try {
                this.setAttribute(ATTR_HREF, href);
                this.uri = new URI(href);
            }
            catch (URISyntaxException e) {
                throw new InvalidInputException("Error processing URI: " + e.getMessage());
            }
        }
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "href": {
                this.uri = this.getUrlAttribute(item);
                this.setAttribute(ATTR_HREF, this.uri.toString());
                break;
            }
            default: {
                super.buildAttribute(item);
            }
        }
    }

    @Override
    void asPresentationML(XmlPrintStream out) {
        out.openElement(this.getMessageMLTag(), this.getAttributes());
        if (this.getChildren().isEmpty()) {
            out.print(out.escape(this.getUri().toString()));
        } else {
            for (Element child : this.getChildren()) {
                child.asPresentationML(out);
            }
        }
        out.closeElement();
    }

    @Override
    public Node asMarkdown() {
        return new org.commonmark.node.Link(this.getUri().toString(), this.getUri().toString());
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.uri == null) {
            throw new InvalidInputException("The attribute \"href\" is required");
        }
        if (StringUtils.isBlank((CharSequence)this.uri.toString())) {
            throw new InvalidInputException("The attribute \"href\" cannot be empty");
        }
        if (!this.uri.isAbsolute()) {
            throw new InvalidInputException("The attribute \"href\" must contain an absolute URI");
        }
        try {
            this.dataProvider.validateURI(this.uri);
        }
        catch (ProcessingException e) {
            throw new InvalidInputException(e.getMessage());
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI url) {
        this.uri = url;
    }

    public String toString() {
        return "Link(" + this.uri + ")";
    }

    @Override
    public String asText() {
        return this.uri.toString();
    }
}

