/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.entityjson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfigurationBuilder;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonSchemaFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.symphonyoss.symphony.entityjson.EntityJson;
import org.symphonyoss.symphony.entityjson.EntityJsonContext;
import org.symphonyoss.symphony.entityjson.EntityJsonURIDownloader;
import org.symphonyoss.symphony.entityjson.IEntityJsonContext;
import org.symphonyoss.symphony.entityjson.IEntityJsonInstanceContext;
import org.symphonyoss.symphony.entityjson.IEntityJsonSchemaContext;
import org.symphonyoss.symphony.entityjson.InvalidInstanceException;
import org.symphonyoss.symphony.entityjson.InvalidSchemaException;
import org.symphonyoss.symphony.entityjson.NoSchemaException;
import org.symphonyoss.symphony.entityjson.SchemaValidationException;
import org.symphonyoss.symphony.entityjson.StructuredObject;

public class EntityJsonParser {
    public static final URL JSON_SCHEMA_SCHEMA_URL = EntityJsonParser.getURL("/schema/org/json-schema/draft-04/schema.json");
    public static final URL ENTITY_JSON_SCHEMA_URL = EntityJsonParser.getURL("/schema/entity-json-v0_1.json");
    public static final URL ENTITY_JSON_EXAMPLE_URL = EntityJsonParser.getURL("/example/entity-json-01.json");
    public static final URL STRUCTURED_OBJECT_SCHEMA_URL = EntityJsonParser.getURL("/schema/structured-object-v0_1.json");
    static final URL BOND_RFQ_SCHEMA_URL = EntityJsonParser.getURL("/proposed/org/symphonyoss/fin/rfq/request/bond-v0_1.json");
    static final URL BOND_RFQ_EXAMPLE_URL = EntityJsonParser.getURL("/example/org/symphonyoss/fin/rfq/request/bond-01.json");
    private final JsonSchemaFactory factory_;

    private static URL getURL(String url) {
        try {
            return new URL("https://schemas.oss.symphony.com" + url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL", e);
        }
    }

    EntityJsonParser(boolean unrestrictedSchemaLoad) {
        if (unrestrictedSchemaLoad) {
            this.factory_ = JsonSchemaFactory.byDefault();
        } else {
            JsonSchemaFactoryBuilder builder = JsonSchemaFactory.newBuilder();
            LoadingConfigurationBuilder loadingCfgBuilder = LoadingConfiguration.newBuilder();
            loadingCfgBuilder.addScheme("http", EntityJsonURIDownloader.getInstance());
            loadingCfgBuilder.addScheme("https", EntityJsonURIDownloader.getInstance());
            LoadingConfiguration loadingCfg = loadingCfgBuilder.freeze();
            builder.setLoadingConfiguration(loadingCfg);
            this.factory_ = builder.freeze();
        }
    }

    public EntityJson parseEntityJson(URL instanceUrl) throws SchemaValidationException, InvalidInstanceException {
        try {
            return new EntityJson(this.validate(ENTITY_JSON_SCHEMA_URL, instanceUrl));
        }
        catch (InvalidSchemaException | NoSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    public EntityJson parseEntityJson(Object instanceSource, Reader instanceReader) throws SchemaValidationException, InvalidInstanceException {
        try {
            return new EntityJson(this.validate(ENTITY_JSON_SCHEMA_URL, instanceSource, instanceReader));
        }
        catch (InvalidSchemaException | NoSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    public EntityJson parseEntityJson(Object instanceSource, ObjectNode instance) throws SchemaValidationException, InvalidInstanceException {
        try {
            return new EntityJson(this.validate(ENTITY_JSON_SCHEMA_URL, instanceSource, instance));
        }
        catch (InvalidSchemaException | NoSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    public StructuredObject parseStructuredObject(URL instanceUrl) throws SchemaValidationException, InvalidInstanceException {
        try {
            return new StructuredObject(this.validate(STRUCTURED_OBJECT_SCHEMA_URL, instanceUrl));
        }
        catch (InvalidSchemaException | NoSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    public StructuredObject parseStructuredObject(Object instanceSource, Reader instanceReader) throws SchemaValidationException, InvalidInstanceException {
        try {
            return new StructuredObject(this.validate(STRUCTURED_OBJECT_SCHEMA_URL, instanceSource, instanceReader));
        }
        catch (InvalidSchemaException | NoSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    public StructuredObject parseStructuredObject(Object instanceSource, ObjectNode instance) throws SchemaValidationException {
        try {
            return new StructuredObject(this.validate(STRUCTURED_OBJECT_SCHEMA_URL, instanceSource, instance));
        }
        catch (InvalidSchemaException | NoSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    IEntityJsonSchemaContext validate(Object schemaSource, ObjectNode schema, Object instanceSource, ObjectNode instance) throws SchemaValidationException {
        return this.validate(EntityJsonContext.newInstance().withInstance(instanceSource, instance).withSchema(schemaSource, schema));
    }

    IEntityJsonSchemaContext validate(URL schemaUrl, Object instanceSource, ObjectNode instance) throws SchemaValidationException, NoSchemaException, InvalidSchemaException {
        IEntityJsonInstanceContext context = EntityJsonContext.newInstance().withInstance(instanceSource, instance);
        return this.validate(context.withSchema(schemaUrl, this.getSchemaJsonNode(context, schemaUrl)));
    }

    IEntityJsonSchemaContext validate(URL schemaUrl, URL instanceUrl) throws SchemaValidationException, InvalidInstanceException, NoSchemaException, InvalidSchemaException {
        IEntityJsonContext context = EntityJsonContext.newInstance();
        return this.validate(context.withInstance(instanceUrl, this.getInstanceJsonNode(context, instanceUrl)).withSchema(schemaUrl, this.getSchemaJsonNode(context, schemaUrl)));
    }

    IEntityJsonSchemaContext validate(URL schemaUrl, Object instanceSource, Reader in) throws SchemaValidationException, InvalidInstanceException, NoSchemaException, InvalidSchemaException {
        IEntityJsonContext context = EntityJsonContext.newInstance();
        return this.validate(context.withInstance(instanceSource, this.getInstanceJsonNode(context, in)).withSchema(schemaUrl, this.getSchemaJsonNode(context, schemaUrl)));
    }

    private IEntityJsonSchemaContext validate(IEntityJsonSchemaContext context) throws SchemaValidationException {
        try {
            ProcessingReport validationResult = this.factory_.getJsonSchema((JsonNode)context.getSchemaJsonNode()).validate((JsonNode)context.getInstanceJsonNode(), true);
            context.withValidationResult(validationResult);
            if (!validationResult.isSuccess()) {
                throw new SchemaValidationException(context);
            }
            return context.withValidationResult(validationResult);
        }
        catch (ProcessingException e) {
            throw new SchemaValidationException((IEntityJsonContext)context, (Throwable)e);
        }
    }

    private ObjectNode getSchemaJsonNode(IEntityJsonContext context, URL url) throws NoSchemaException, InvalidSchemaException {
        ObjectNode objectNode;
        block8: {
            Reader in = this.getSchemaReader(context, url);
            try {
                ObjectMapper mapper = new ObjectMapper();
                objectNode = (ObjectNode)mapper.readTree(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ClassCastException e) {
                    throw new InvalidSchemaException(context, (Throwable)e);
                }
            }
            in.close();
        }
        return objectNode;
    }

    private Reader getSchemaReader(IEntityJsonContext context, URL url) throws NoSchemaException, InvalidSchemaException {
        try {
            return new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new NoSchemaException(context, (Throwable)e);
        }
        catch (IOException e) {
            throw new InvalidSchemaException(context, (Throwable)e);
        }
    }

    private ObjectNode getInstanceJsonNode(IEntityJsonContext context, URL url) throws InvalidInstanceException {
        ObjectNode objectNode;
        block8: {
            Reader in = this.getInstanceReader(context, url);
            try {
                objectNode = this.getInstanceJsonNode(context, in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidInstanceException(context, (Throwable)e);
                }
            }
            in.close();
        }
        return objectNode;
    }

    private ObjectNode getInstanceJsonNode(IEntityJsonContext context, Reader in) throws InvalidInstanceException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (ObjectNode)mapper.readTree(in);
        }
        catch (IOException | ClassCastException e) {
            throw new InvalidInstanceException(context, (Throwable)e);
        }
    }

    private Reader getInstanceReader(IEntityJsonContext context, URL url) throws InvalidInstanceException {
        try {
            return new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new InvalidInstanceException(context, (Throwable)e);
        }
    }
}

