/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Entity;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.EmojiNode;
import org.symphonyoss.symphony.messageml.util.EmojiShortcodeToUnicode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class Emoji
extends Entity {
    public static final String MESSAGEML_TAG = "emoji";
    @Deprecated
    private static final String ATTR_ANNOTATION = "annotation";
    private static final String ATTR_SHORTCODE = "shortcode";
    private static final String SHORTCODE_PATTERN = "[\\p{Alnum}_+-]*";
    private static final String ATTR_FAMILY = "family";
    private static final String ATTR_SIZE = "size";
    private static final String ENTITY_TYPE = "com.symphony.emoji";
    private static final String ENTITY_VERSION = "1.0";
    private static final String ENTITY_ID_PREFIX = "emoji";
    private static final String DELIMITER = ":";
    private static final String DATA_FIELD = "data";
    private static final String UNICODE_FIELD = "unicode";
    private static final String DEFAULT_EMOJI_SIZE = "normal";
    @Deprecated
    private String annotation;
    private String shortcode;
    private String family;
    private String size;

    public Emoji(Element parent, String shortcode, int entityIndex) {
        this(parent, entityIndex);
        this.annotation = shortcode;
        this.shortcode = shortcode;
    }

    public Emoji(Element parent, int entityIndex) {
        super(parent, "emoji", "span", FormatEnum.MESSAGEML);
        this.entityId = this.getEntityId(entityIndex);
        this.size = DEFAULT_EMOJI_SIZE;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getShortCode() {
        return this.shortcode;
    }

    public String getFamily() {
        return this.family;
    }

    public String getSize() {
        return this.size;
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.openElement(this.presentationMLTag, "class", "entity", "data-entity-id", this.entityId);
        if (this.getChildren().isEmpty()) {
            out.append(this.asDefaultRepresentation());
        } else {
            for (Element child : this.getChildren()) {
                child.asPresentationML(out, context);
            }
        }
        out.closeElement();
    }

    @Override
    public Node asMarkdown() throws InvalidInputException {
        return new EmojiNode(this.shortcode);
    }

    @Override
    public String asText() {
        StringBuilder b = new StringBuilder();
        if (this.getChildren().isEmpty()) {
            b.append(this.asDefaultRepresentation());
        } else {
            for (Element child : this.getChildren()) {
                b.append(child.asText());
            }
        }
        return b.toString();
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        JsonNode entityNode = parent.path(this.entityId);
        if (entityNode.isMissingNode()) {
            ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
            node.put("type", this.getEntityType());
            node.put("version", this.getEntityVersion());
            ObjectNode idNode = new ObjectNode(JsonNodeFactory.instance);
            idNode.put(ATTR_SHORTCODE, this.getShortCode());
            idNode.put(ATTR_ANNOTATION, this.getAnnotation());
            idNode.put(ATTR_SIZE, this.getSize());
            if (EmojiShortcodeToUnicode.hasUnicodeRepresentation(this.shortcode).booleanValue()) {
                idNode.put(UNICODE_FIELD, EmojiShortcodeToUnicode.getUnicode(this.shortcode));
            }
            if (this.getFamily() != null) {
                idNode.put(ATTR_FAMILY, this.getFamily());
            }
            node.set(DATA_FIELD, (JsonNode)idNode);
            parent.set(this.entityId, (JsonNode)node);
            return node;
        }
        return (ObjectNode)entityNode;
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.shortcode == null) {
            throw new InvalidInputException("Either the attribute \"shortcode\" or \"annotation\" are required");
        }
        if (!this.shortcode.matches(SHORTCODE_PATTERN)) {
            throw new InvalidInputException("Shortcode or Annotation parameter may only contain alphanumeric characters, underscore, plus sign and dash");
        }
        this.assertPhrasingContent();
    }

    public String toString() {
        return "Emoji(" + this.getShortCode() + ")";
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "shortcode": 
            case "annotation": {
                this.annotation = this.shortcode = this.getStringAttribute(item);
                break;
            }
            case "family": {
                this.family = this.getStringAttribute(item);
                break;
            }
            case "size": {
                this.size = this.getStringAttribute(item);
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    protected String getEntityValue() {
        return this.shortcode;
    }

    @Override
    protected String getEntitySubType() {
        return null;
    }

    @Override
    protected String getEntityVersion() {
        return ENTITY_VERSION;
    }

    @Override
    protected String getEntityType() {
        return ENTITY_TYPE;
    }

    @Override
    protected String getEntityIdPrefix() {
        return "emoji";
    }

    @Override
    public void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        context.updateItemCount(BiFields.EMOJIS.getValue());
        context.addItem(new BiItem(BiFields.ENTITY.getValue(), Collections.singletonMap(BiFields.ENTITY_TYPE.getValue(), this.getEntityType())));
    }

    private String asDefaultRepresentation() {
        if (EmojiShortcodeToUnicode.hasUnicodeRepresentation(this.shortcode).booleanValue()) {
            return EmojiShortcodeToUnicode.getUnicode(this.shortcode);
        }
        return DELIMITER + this.shortcode + DELIMITER;
    }
}

