/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.HashMap;
import java.util.Map;
import org.symphonyoss.symphony.messageml.elements.SplittableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.w3c.dom.Node;

public interface LabelableElement
extends SplittableElement {
    public static final String LABEL = "label";
    public static final String LABEL_FOR = "for";
    public static final int LABEL_MAX_LENGTH = 256;
    public static final String LABEL_TOO_LONG_ERR = "The attribute label value is too long. Max length is: %d";

    default public String getPresentationMLLabelTag() {
        return LABEL;
    }

    default public Map<String, String> getLabelAttribute(String id) {
        HashMap<String, String> labelAttributes = new HashMap<String, String>();
        labelAttributes.put(LABEL_FOR, id);
        return labelAttributes;
    }

    default public boolean isLabel() {
        return this.getAttribute(LABEL) != null;
    }

    default public boolean isLabelNode(Node item) {
        return this.getPresentationMLLabelTag().equals(item.getNodeName());
    }

    default public void validateLabel() throws InvalidInputException {
        String labelAttribute = this.getAttribute(LABEL);
        if (labelAttribute != null && labelAttribute.length() > 256) {
            throw new InvalidInputException(String.format(LABEL_TOO_LONG_ERR, 256));
        }
    }
}

