/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.bi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;

public class BiContext {
    private static final Logger logger = LoggerFactory.getLogger(BiContext.class);
    public static final String LIBRARY_VERSION = BiContext.extractVersion();
    private final List<BiItem> items = new ArrayList<BiItem>();

    public List<BiItem> getItems() {
        return this.items;
    }

    public void addItem(BiItem item) {
        this.items.add(item);
    }

    public void addItemWithValue(String itemName, Object itemValue) {
        BiItem item = new BiItem(itemName, Collections.singletonMap(BiFields.COUNT.getValue(), itemValue));
        this.items.add(item);
    }

    public void updateItemCount(String itemName, String attributeName) {
        Optional<BiItem> optionalBiItem = this.getItemWithName(itemName);
        if (optionalBiItem.isPresent()) {
            optionalBiItem.get().increaseAttributeCount(attributeName);
        } else {
            this.addItem(new BiItem(itemName, attributeName));
        }
    }

    public void updateItemCount(String itemName) {
        Optional<BiItem> optionalBiItem = this.getItemWithName(itemName);
        if (optionalBiItem.isPresent()) {
            optionalBiItem.get().increaseAttributeCount(BiFields.COUNT.getValue());
        } else {
            this.addItem(new BiItem(itemName, BiFields.COUNT.getValue()));
        }
    }

    public void updateItemCount(String itemName, Map<String, Object> attributes) {
        Optional<BiItem> optionalBiItem = this.getItemWithName(itemName);
        if (optionalBiItem.isPresent()) {
            attributes.forEach((key, value) -> {
                if (!StringUtils.isEmpty((CharSequence)String.valueOf(value)) && ((BiItem)optionalBiItem.get()).getAttributes().get(key) != null) {
                    ((BiItem)optionalBiItem.get()).increaseAttributeCount((String)key);
                } else {
                    ((BiItem)optionalBiItem.get()).getAttributes().putIfAbsent((String)key, value);
                }
            });
        } else {
            this.addItem(new BiItem(itemName, attributes));
        }
    }

    public void updateItemWithMaxValue(String itemName, Integer attributeValue) {
        Optional<BiItem> optionalBiItem = this.getItemWithName(itemName);
        if (optionalBiItem.isPresent()) {
            optionalBiItem.get().setMaxAttribute(BiFields.COUNT.getValue(), attributeValue);
        } else {
            HashMap<String, Object> attributesMap = new HashMap<String, Object>();
            attributesMap.put(BiFields.COUNT.getValue(), attributeValue);
            this.addItem(new BiItem(itemName, attributesMap));
        }
    }

    public boolean isAttributeSet(String itemName, String attributeName) {
        Optional<BiItem> optionalBiTem = this.getItemWithName(itemName);
        return optionalBiTem.isPresent() && optionalBiTem.get().getAttributes() != null && optionalBiTem.get().getAttributes().get(attributeName) != null;
    }

    private Optional<BiItem> getItemWithName(String itemName) {
        return this.getItems().stream().filter(item -> item.getName().equals(itemName)).findFirst();
    }

    private static String extractVersion() {
        String version = BiContext.class.getPackage().getImplementationVersion();
        if (version == null || version.isEmpty()) {
            logger.warn("Failed to extract the messageML library version.");
            version = "Unknown";
        }
        return "MessageML " + version;
    }
}

