/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.pod.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.pod.model.AdminStreamTypeEnum;

@ApiModel(description="stream filter criteria")
public class AdminStreamFilter {
    @JsonProperty(value="streamTypes")
    private List<AdminStreamTypeEnum> streamTypes = new ArrayList<AdminStreamTypeEnum>();
    @JsonProperty(value="scope")
    private ScopeEnum scope = null;
    @JsonProperty(value="origin")
    private OriginEnum origin = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="privacy")
    private PrivacyEnum privacy = null;
    @JsonProperty(value="startDate")
    private Long startDate = null;
    @JsonProperty(value="endDate")
    private Long endDate = null;

    public AdminStreamFilter streamTypes(List<AdminStreamTypeEnum> streamTypes) {
        this.streamTypes = streamTypes;
        return this;
    }

    public AdminStreamFilter addStreamTypesItem(AdminStreamTypeEnum streamTypesItem) {
        this.streamTypes.add(streamTypesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="type of streams to search for")
    public List<AdminStreamTypeEnum> getStreamTypes() {
        return this.streamTypes;
    }

    public void setStreamTypes(List<AdminStreamTypeEnum> streamTypes) {
        this.streamTypes = streamTypes;
    }

    public AdminStreamFilter scope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(example="null", value="scope of the room.  If not specified, it will include both Internal and External scope")
    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public AdminStreamFilter origin(OriginEnum origin) {
        this.origin = origin;
        return this;
    }

    @ApiModelProperty(example="null", value="Origin of the room. It indicate whether the room was created by a user within the company by another company.  If not specified, it will include both Internal and External origin ")
    public OriginEnum getOrigin() {
        return this.origin;
    }

    public void setOrigin(OriginEnum origin) {
        this.origin = origin;
    }

    public AdminStreamFilter status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of the room. If not specified, it will include both Active and Inactive status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AdminStreamFilter privacy(PrivacyEnum privacy) {
        this.privacy = privacy;
        return this;
    }

    @ApiModelProperty(example="null", value="Privacy setting of the stream.  If not specified, it will include both public and private stream")
    public PrivacyEnum getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(PrivacyEnum privacy) {
        this.privacy = privacy;
    }

    public AdminStreamFilter startDate(Long startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Start date in unix timestamp in millseconds")
    public Long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    public AdminStreamFilter endDate(Long endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", value="End date in unix timestamp in millseconds.  If not specified, it assume to be current time.")
    public Long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminStreamFilter adminStreamFilter = (AdminStreamFilter)o;
        return Objects.equals(this.streamTypes, adminStreamFilter.streamTypes) && Objects.equals((Object)this.scope, (Object)adminStreamFilter.scope) && Objects.equals((Object)this.origin, (Object)adminStreamFilter.origin) && Objects.equals((Object)this.status, (Object)adminStreamFilter.status) && Objects.equals((Object)this.privacy, (Object)adminStreamFilter.privacy) && Objects.equals(this.startDate, adminStreamFilter.startDate) && Objects.equals(this.endDate, adminStreamFilter.endDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.streamTypes, this.scope, this.origin, this.status, this.privacy, this.startDate, this.endDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminStreamFilter {\n");
        sb.append("    streamTypes: ").append(this.toIndentedString(this.streamTypes)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString((Object)this.origin)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    privacy: ").append(this.toIndentedString((Object)this.privacy)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PrivacyEnum {
        PUBLIC("PUBLIC"),
        PRIVATE("PRIVATE");

        private String value;

        private PrivacyEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrivacyEnum fromValue(String text) {
            for (PrivacyEnum b : PrivacyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum OriginEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private OriginEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OriginEnum fromValue(String text) {
            for (OriginEnum b : OriginEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ScopeEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private ScopeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScopeEnum fromValue(String text) {
            for (ScopeEnum b : ScopeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

