/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.pod.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.pod.model.MessageStatusUser;

@ApiModel(description="Holds the status of a particular message, indicating which user the message has been sent, delivered or read. ")
public class MessageStatus {
    @JsonProperty(value="read")
    private List<MessageStatusUser> read = new ArrayList<MessageStatusUser>();
    @JsonProperty(value="delivered")
    private List<MessageStatusUser> delivered = new ArrayList<MessageStatusUser>();
    @JsonProperty(value="sent")
    private List<MessageStatusUser> sent = new ArrayList<MessageStatusUser>();

    public MessageStatus read(List<MessageStatusUser> read) {
        this.read = read;
        return this;
    }

    public MessageStatus addReadItem(MessageStatusUser readItem) {
        this.read.add(readItem);
        return this;
    }

    @ApiModelProperty(example="null", value="All users who have read that message, in any Symphony client.")
    public List<MessageStatusUser> getRead() {
        return this.read;
    }

    public void setRead(List<MessageStatusUser> read) {
        this.read = read;
    }

    public MessageStatus delivered(List<MessageStatusUser> delivered) {
        this.delivered = delivered;
        return this;
    }

    public MessageStatus addDeliveredItem(MessageStatusUser deliveredItem) {
        this.delivered.add(deliveredItem);
        return this;
    }

    @ApiModelProperty(example="null", value="All users who have at least one Symphony client to which the message has been delivered, and not read yet. ")
    public List<MessageStatusUser> getDelivered() {
        return this.delivered;
    }

    public void setDelivered(List<MessageStatusUser> delivered) {
        this.delivered = delivered;
    }

    public MessageStatus sent(List<MessageStatusUser> sent) {
        this.sent = sent;
        return this;
    }

    public MessageStatus addSentItem(MessageStatusUser sentItem) {
        this.sent.add(sentItem);
        return this;
    }

    @ApiModelProperty(example="null", value="All users to whom the message has been sent and received by the Symphony system, but not yet delivered to any user's Symphony client. ")
    public List<MessageStatusUser> getSent() {
        return this.sent;
    }

    public void setSent(List<MessageStatusUser> sent) {
        this.sent = sent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageStatus messageStatus = (MessageStatus)o;
        return Objects.equals(this.read, messageStatus.read) && Objects.equals(this.delivered, messageStatus.delivered) && Objects.equals(this.sent, messageStatus.sent);
    }

    public int hashCode() {
        return Objects.hash(this.read, this.delivered, this.sent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageStatus {\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("    delivered: ").append(this.toIndentedString(this.delivered)).append("\n");
        sb.append("    sent: ").append(this.toIndentedString(this.sent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

