/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.pod.api;

import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;
import org.symphonyoss.symphony.pod.model.SuccessResponse;
import org.symphonyoss.symphony.pod.model.UserConnection;
import org.symphonyoss.symphony.pod.model.UserConnectionList;
import org.symphonyoss.symphony.pod.model.UserConnectionRequest;

public class ConnectionApi {
    private ApiClient apiClient;

    public ConnectionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConnectionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserConnection v1ConnectionAcceptPost(String sessionToken, UserConnectionRequest connectionRequest) throws ApiException {
        UserConnectionRequest localVarPostBody = connectionRequest;
        if (sessionToken == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionAcceptPost");
        }
        if (connectionRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionRequest' when calling v1ConnectionAcceptPost");
        }
        String localVarPath = "/v1/connection/accept";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sessionToken != null) {
            localVarHeaderParams.put("sessionToken", this.apiClient.parameterToString(sessionToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserConnection> localVarReturnType = new GenericType<UserConnection>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserConnection v1ConnectionCreatePost(String sessionToken, UserConnectionRequest connectionRequest) throws ApiException {
        UserConnectionRequest localVarPostBody = connectionRequest;
        if (sessionToken == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionCreatePost");
        }
        if (connectionRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionRequest' when calling v1ConnectionCreatePost");
        }
        String localVarPath = "/v1/connection/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sessionToken != null) {
            localVarHeaderParams.put("sessionToken", this.apiClient.parameterToString(sessionToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserConnection> localVarReturnType = new GenericType<UserConnection>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserConnectionList v1ConnectionListGet(String sessionToken, String status, String userIds) throws ApiException {
        Object localVarPostBody = null;
        if (sessionToken == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionListGet");
        }
        String localVarPath = "/v1/connection/list";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "userIds", userIds));
        if (sessionToken != null) {
            localVarHeaderParams.put("sessionToken", this.apiClient.parameterToString(sessionToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserConnectionList> localVarReturnType = new GenericType<UserConnectionList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserConnection v1ConnectionRejectPost(String sessionToken, UserConnectionRequest connectionRequest) throws ApiException {
        UserConnectionRequest localVarPostBody = connectionRequest;
        if (sessionToken == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionRejectPost");
        }
        if (connectionRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionRequest' when calling v1ConnectionRejectPost");
        }
        String localVarPath = "/v1/connection/reject";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sessionToken != null) {
            localVarHeaderParams.put("sessionToken", this.apiClient.parameterToString(sessionToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserConnection> localVarReturnType = new GenericType<UserConnection>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SuccessResponse v1ConnectionUserUidRemovePost(String sessionToken, Long uid) throws ApiException {
        Object localVarPostBody = null;
        if (sessionToken == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionUserUidRemovePost");
        }
        if (uid == null) {
            throw new ApiException(400, "Missing the required parameter 'uid' when calling v1ConnectionUserUidRemovePost");
        }
        String localVarPath = "/v1/connection/user/{uid}/remove".replaceAll("\\{uid\\}", this.apiClient.escapeString(uid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sessionToken != null) {
            localVarHeaderParams.put("sessionToken", this.apiClient.parameterToString(sessionToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SuccessResponse> localVarReturnType = new GenericType<SuccessResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserConnection v1ConnectionUserUserIdInfoGet(String sessionToken, String userId) throws ApiException {
        Object localVarPostBody = null;
        if (sessionToken == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConnectionUserUserIdInfoGet");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling v1ConnectionUserUserIdInfoGet");
        }
        String localVarPath = "/v1/connection/user/{userId}/info".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sessionToken != null) {
            localVarHeaderParams.put("sessionToken", this.apiClient.parameterToString(sessionToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserConnection> localVarReturnType = new GenericType<UserConnection>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

